/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.search;

import com.infusers.core.search.ISpecificationModel;
import com.infusers.core.search.SpecificationConfigElement;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;

public class SpecificationUtility {
    public static String getSearchLikeString(String searchString) {
        Object likeSearchString = !searchString.contains("%") ? "%" + searchString.toLowerCase() + "%" : searchString.toLowerCase();
        return likeSearchString;
    }

    static Predicate createPredicate(Root<ISpecificationModel> root, CriteriaBuilder criteriaBuilder, SpecificationConfigElement element, String searchString, String likeSearchString) {
        if (element == null) {
            return null;
        }
        if (element.getSourceDataType() == String.class) {
            return SpecificationUtility.createPredicateString(root, criteriaBuilder, element.getFieldName(), searchString, likeSearchString);
        }
        if (element.getSourceDataType() == Boolean.class) {
            return SpecificationUtility.createPredicateBoolean(root, criteriaBuilder, element.getFieldName(), searchString, likeSearchString);
        }
        if (element.getSourceDataType() == Date.class) {
            return SpecificationUtility.createPredicateDate(root, criteriaBuilder, element.getFieldName(), searchString, likeSearchString);
        }
        if (element.getSourceDataType() == Long.class) {
            return SpecificationUtility.createPredicateLong(root, criteriaBuilder, element.getFieldName(), searchString, likeSearchString);
        }
        return null;
    }

    static Predicate createPredicateBoolean(Root<ISpecificationModel> root, CriteriaBuilder criteriaBuilder, String fieldName, String searchString, String likeSearchString) {
        if (searchString != null && !searchString.isEmpty()) {
            try {
                boolean searchBoolean = Boolean.getBoolean(searchString);
                return criteriaBuilder.equal((Expression)root.get(fieldName), (Object)searchBoolean);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static Predicate createPredicateDate(Root<ISpecificationModel> root, CriteriaBuilder criteriaBuilder, String fieldName, String searchString, String likeSearchString) {
        if (searchString != null && !searchString.isEmpty()) {
            Expression dateStringExpr = criteriaBuilder.function("TO_CHAR", String.class, new Expression[]{root.get("createdAt"), criteriaBuilder.literal((Object)"YYYY-MM-DD HH:MI:SS")});
            return criteriaBuilder.like(dateStringExpr, likeSearchString);
        }
        return null;
    }

    static Predicate createPredicateString(Root<ISpecificationModel> root, CriteriaBuilder criteriaBuilder, String fieldName, String searchString, String likeSearchString) {
        if (searchString != null && !searchString.isEmpty()) {
            return criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get(fieldName)), likeSearchString);
        }
        return null;
    }

    static Predicate createPredicateLong(Root<ISpecificationModel> root, CriteriaBuilder criteriaBuilder, String fieldName, String searchString, String likeSearchString) {
        Long searchLong = 0L;
        try {
            searchLong = Long.parseLong(searchString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (searchLong != null && searchLong.intValue() != 0) {
            return criteriaBuilder.like(root.get(fieldName).as(String.class), likeSearchString);
        }
        return null;
    }

    static Predicate joinPredicateMultipleOr(CriteriaBuilder criteriaBuilder, ArrayList<Predicate> predicateListOr) {
        Predicate predicateSearch = null;
        int count = predicateListOr != null ? predicateListOr.size() : 0;
        for (int i = 0; i < count; ++i) {
            Predicate searchOr = predicateListOr.get(i);
            predicateSearch = SpecificationUtility.joinPredicatesOr(criteriaBuilder, predicateSearch, searchOr);
        }
        return predicateSearch;
    }

    static Predicate joinPredicatesOr(CriteriaBuilder criteriaBuilder, Predicate master, Predicate slave) {
        if (master != null && slave != null) {
            return criteriaBuilder.or((Expression)master, (Expression)slave);
        }
        if (master != null) {
            return master;
        }
        if (slave != null) {
            return slave;
        }
        return null;
    }

    static Predicate joinPredicatesAnd(CriteriaBuilder criteriaBuilder, Predicate master, Predicate slave) {
        if (master != null && slave != null) {
            return criteriaBuilder.and((Expression)master, (Expression)slave);
        }
        if (master != null) {
            return master;
        }
        if (slave != null) {
            return slave;
        }
        return null;
    }
}

