/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.order;

import com.infusers.core.order.OrderItem;
import com.infusers.core.search.ISpecificationModel;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.SequenceGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity
public class CustomerOrder
implements ISpecificationModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INFUSERS")
    @SequenceGenerator(name="INFUSERS", sequenceName="CO_SEQ", allocationSize=1)
    private Long id;
    private Date createdAt;
    private String userName;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="id")
    private List<OrderItem> orderItemList = new ArrayList<OrderItem>();

    @PrePersist
    void createdAt() {
        this.createdAt = new Date();
    }

    public CustomerOrder() {
        this.createdAt();
    }

    public CustomerOrder(Long id, List<OrderItem> orderItemList, String userName) {
        this.id = id;
        this.orderItemList = orderItemList;
        this.userName = userName;
        this.createdAt();
    }

    public CustomerOrder(String userName) {
        this.userName = userName;
        this.createdAt();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<OrderItem> getOrderItemList() {
        return this.orderItemList;
    }

    public void setOrderItemList(List<OrderItem> orderItemList) {
        this.orderItemList = orderItemList;
    }

    public void addOrderItem(OrderItem orderItem) {
        this.orderItemList.add(orderItem);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
}

