/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.email;

import com.infusers.core.user.dto.UserDetailsDto;
import com.infusers.core.util.InfusersUtility;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RemoteEmailUtility {
    final Logger log = LogManager.getLogger(RemoteEmailUtility.class);
    private static final String CLASS_NAME = "RemoteEmailUtility";
    @Value(value="${infusers.email.endpoint}")
    private String emailEndPoint;
    @Value(value="${infusers.email.url}")
    private String host;
    @Value(value="${infusers.auth.verify.url}")
    private String authVerifyEndPoint;
    @Value(value="${myapp.rom.request.mapping}")
    private String requestMapping;
    @Value(value="${infusers.token.inter.api.communication}")
    private String infuserTokenInterApiCommunication;

    public boolean sendEmailNewAccountCreated(UserDetailsDto user) {
        if (user == null) {
            this.log.error("RemoteEmailUtility.sendEmailNewAccountCreated()--> user is NULL." + user);
            return false;
        }
        String subject = "Warm welcome to Infusers!! Please verify your registration.";
        String content = "You have created a new Account!<br>Please click the link below to verify your registration:<br><h3><a href=\"[[URL]]\" target=\"_self\">VERIFY</a></h3>";
        String verifyURL = this.authVerifyEndPoint + "?code=" + user.getVerificationCode();
        content = content.replace("[[URL]]", verifyURL);
        return this.sendEmail(user.getUsername(), subject, content);
    }

    public boolean sendEmailUserLoggedIn(String userName) {
        String subject = "Dear Infuser, Welcome Back :)";
        String message = "Thank you for your continued support in using Infuser's services, Have a great time ahead!!";
        return this.sendEmail(userName, subject, message);
    }

    public boolean sendEmail(String userName, String subject, String message) {
        this.log.debug("RemoteEmailUtility.sendEmail() userName : " + userName);
        String urlString = this.host + this.requestMapping + this.emailEndPoint + "/" + userName;
        String endpoint = "";
        try {
            boolean returnVal;
            String bearerToken = InfusersUtility.getInstance().getToken(userName);
            URI uri = new URIBuilder(urlString).addParameter("subject", subject).addParameter("message", message).build();
            endpoint = uri.toString();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost(endpoint);
            request.addHeader("content-type", "application/json");
            request.setHeader("Authorization", "Bearer " + bearerToken);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            boolean bl = returnVal = response.getStatusLine().getStatusCode() == 200;
            if (returnVal) {
                this.log.debug("RemoteEmailUtility.sendEmail() userName : " + userName + " :: response code = " + response.getStatusLine().getStatusCode());
            } else {
                this.log.error("RemoteEmailUtility.sendEmail() userName : " + userName + " :: response code = " + response.getStatusLine().getStatusCode() + " :: endpoint = " + endpoint);
            }
            return returnVal;
        }
        catch (Exception e) {
            this.log.error("RemoteEmailUtility.sendEmail()" + e.getMessage());
            return false;
        }
    }
}

