/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.cache.redis;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class InfuserCacheClearingComponent {
    private Logger log = LogManager.getLogger(InfuserCacheClearingComponent.class);
    private final ApplicationContext applicationContext;

    @Autowired
    public InfuserCacheClearingComponent(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void clearCache() {
        String[] redisTemplateNames;
        for (String redisTemplateName : redisTemplateNames = this.applicationContext.getBeanNamesForType(RedisTemplate.class)) {
            RedisTemplate redisTemplate = (RedisTemplate)this.applicationContext.getBean(redisTemplateName, RedisTemplate.class);
            redisTemplate.getConnectionFactory().getConnection().flushDb();
        }
        this.log.info("===========================================================================================================");
        this.log.warn("InfuserCacheClearingComponent.clearCache() --> Redis cache cleared on Startup/Shutdown/On New user created!!");
        this.log.info("============================================================================================================");
    }
}

