/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.infusers.core.audit.AuditRecord;
import com.infusers.core.audit.AuditService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AwsS3Service {
    @Autowired
    private AmazonS3 amazonS3Client;
    @Autowired(required=true)
    private AuditService auditService;
    final Logger log = LogManager.getLogger(AwsS3Service.class);
    private static final String CLASS_NAME = "AwsS3Service";
    @Value(value="${infusers.file.aws.s3.bucketname}")
    private String bucketName;

    public String getBucketName() {
        return this.bucketName;
    }

    public boolean isAWSS3Configured() {
        return this.bucketName != null && this.bucketName.trim().length() != 0;
    }

    private boolean createBucket() {
        if (!this.isAWSS3Configured()) {
            return false;
        }
        if (this.amazonS3Client.doesBucketExistV2(this.bucketName)) {
            return true;
        }
        return this.amazonS3Client.createBucket(this.bucketName) != null;
    }

    public InputStreamResource downloadFile(String fileName) throws IOException {
        if (!this.isAWSS3Configured()) {
            this.log.error("AwsS3Service.downloadFile() File delete not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName + " :: fileName = " + fileName);
            this.auditService.createAuditRecord(new AuditRecord(fileName, 1, CLASS_NAME, "downloadFile()-> File delete not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName + " :: fileName = " + fileName));
            return null;
        }
        S3Object s3Object = this.amazonS3Client.getObject(this.bucketName, fileName);
        return new InputStreamResource((InputStream)Objects.requireNonNull(s3Object.getObjectContent()), "File");
    }

    public void deleteFile(String fileName) {
        if (!this.isAWSS3Configured()) {
            this.log.error("AwsS3Service.deleteFile() File delete not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName);
            this.auditService.createAuditRecord(new AuditRecord(fileName, 1, CLASS_NAME, "deleteFile()-> File delete not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName));
            return;
        }
        boolean success = this.createBucket();
        if (success) {
            this.amazonS3Client.deleteObject(this.bucketName, fileName);
        } else {
            this.log.error("AwsS3Service.deleteFile() File delete not possible, bucket doesn't exits/not possible to create/aws is not accessable. bucket name = " + this.bucketName);
            this.auditService.createAuditRecord(new AuditRecord(fileName, 1, CLASS_NAME, "deleteFile()-> File delete not possible, bucket doesn't exits/not possible to create/aws is not accessable. bucket name = " + this.bucketName));
        }
    }

    public void uploadFile(MultipartFile multipartFile, String fileName2Save) throws IOException {
        if (!this.isAWSS3Configured()) {
            this.log.error("AwsS3Service.uploadFile() File upload not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName + " :: fileName2Save = " + fileName2Save);
            this.auditService.createAuditRecord(new AuditRecord(multipartFile.getName(), 1, CLASS_NAME, "uploadFile()-> File upload not possible, bucket name is not configured and/or aws is not accessable. bucket name = " + this.bucketName + ":: fileName2Save = " + fileName2Save));
            return;
        }
        boolean success = this.createBucket();
        if (success) {
            File file = this.convertMultiPartFileToFile(multipartFile);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, fileName2Save, file);
            this.amazonS3Client.putObject(putObjectRequest);
            success = file.delete();
        } else {
            this.log.error("AwsS3Service.uploadFile() File delete not possible, bucket doesn't exits/not possible to create/aws is not accessable. bucket name = " + this.bucketName);
            this.auditService.createAuditRecord(new AuditRecord(fileName2Save, 1, CLASS_NAME, "uploadFile()-> File delete not possible, bucket doesn't exits/not possible to create/aws is not accessable. bucket name = " + this.bucketName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File convertMultiPartFileToFile(MultipartFile multipartFile) throws IOException {
        File file = new File(multipartFile.getOriginalFilename());
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(file);
            outputStream.write(multipartFile.getBytes());
        }
        return file;
    }
}

