/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.audit;

import com.infusers.core.audit.AuditRecord;
import com.infusers.core.audit.AuditRepository;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Service
public class AuditService {
    final Logger log = LogManager.getLogger(AuditService.class);
    @Autowired(required=true)
    private AuditRepository auditRepository;

    public ResponseEntity<Object> createAuditRecord(AuditRecord auditRecord) {
        this.log.debug("AuditService.createAuditRecord() Creating new audit record, audit id = ", (Object)auditRecord.getId());
        try {
            AuditRecord savedAuditRecord = (AuditRecord)this.auditRepository.save(auditRecord);
            URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{savedAuditRecord.getId()}).toUri();
            return ResponseEntity.created((URI)location).build();
        }
        catch (Exception e) {
            this.log.error("AuditService.createAuditRecord() Creating new audit record, audit id = ", (Object)(auditRecord.getId() + " :: error = " + e.getMessage()));
            return null;
        }
    }
}

