/*
 * Decompiled with CFR 0.152.
 */
package com.infusers.core.audit;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.SequenceGenerator;
import java.util.Date;

@Entity
public class AuditRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INFUSERS")
    @SequenceGenerator(name="INFUSERS", sequenceName="AUDIT_SEQ", allocationSize=1)
    private Long id;
    private Date createdAt;
    private String userEmailId;
    private int eventType;
    private String eventName;
    private String eventDescription;

    @PrePersist
    void createdAt() {
        this.createdAt = new Date();
    }

    private AuditRecord() {
        this.createdAt();
    }

    public AuditRecord(String userEmailId, int eventType, String eventName, String eventDescription) {
        this.userEmailId = userEmailId;
        this.eventType = eventType;
        this.eventName = eventName;
        this.eventDescription = eventDescription;
        this.createdAt();
    }

    public Long getId() {
        return this.id;
    }

    public String getUserEmailId() {
        return this.userEmailId;
    }

    public void setUserEmailId(String userEmailId) {
        this.userEmailId = userEmailId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }
}

