/*
 * Decompiled with CFR 0.152.
 */
package icu.lowcoder.spring.commons.jpa.auditing;

import icu.lowcoder.spring.commons.jpa.JpaAuditingProperties;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class AuthenticationAuditorExtractor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationAuditorExtractor.class);
    private final JpaAuditingProperties auditingProperties;

    public AuthenticationAuditorExtractor(JpaAuditingProperties auditingProperties) {
        this.auditingProperties = auditingProperties;
    }

    public Object extractor() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object auditor = null;
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof UUID || principal instanceof String || principal instanceof Integer || principal instanceof Long) {
                auditor = principal;
            } else if (!StringUtils.isEmpty((Object)this.auditingProperties.getAuditorKey())) {
                String[] keys = this.auditingProperties.getAuditorKey().split(",");
                if (principal instanceof Map) {
                    Map properties = (Map)principal;
                    for (String key : keys) {
                        if (!properties.containsKey(key)) continue;
                        auditor = properties.get(key);
                        break;
                    }
                } else {
                    BeanMap beanMap = BeanMap.create((Object)principal);
                    for (String key : keys) {
                        if (!beanMap.containsKey((Object)key)) continue;
                        auditor = beanMap.get((Object)key);
                        break;
                    }
                }
            }
        }
        if (auditor == null) {
            log.warn("can't extractor auditor, key: {}", (Object)this.auditingProperties.getAuditorKey());
        }
        return auditor;
    }
}

