/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.daytrader.client.ws;

import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Stub;
import org.apache.geronimo.samples.daytrader.client.ws.QuoteDataBean;
import org.apache.geronimo.samples.daytrader.client.ws.Trade;
import org.apache.geronimo.samples.daytrader.client.ws.TradeWSServices;

public class ClientScenario
extends Thread {
    protected static final boolean useJNDI = false;
    private long numReqs = 0L;
    private long numErrs = 0L;
    private long numStatReqs = 0L;
    private long totResp = 0L;
    private boolean stop = false;
    private static String servicePort = "http://localhost:8080/daytrader/services/TradeWSServices";
    private static long numThreads = 0L;
    private static long reqPerThread;
    private static long startTime;
    private static long statStartTime;
    private static long intervalStartTime;
    private static long totReqsAtLastInterval;
    private static long minResp;
    private static long maxResp;
    private static final String jndiName = "java:comp/env/service/Trade";
    public static String symbol;
    private static TradeWSServices tradeSingleton;

    public ClientScenario() {
    }

    public ClientScenario(int reqPerThreadIn) {
        System.out.println("Thread " + this.getName() + " ready to execute " + reqPerThread + " iterations");
        reqPerThread = reqPerThreadIn;
    }

    public void run() {
        try {
            TradeWSServices ts = ClientScenario.getTrade();
            int i = 0;
            while ((long)i < reqPerThread) {
                try {
                    if (this.isStop()) {
                        System.out.println("Thread " + this + " stopping");
                        return;
                    }
                    long start = System.currentTimeMillis();
                    QuoteDataBean resp = ts.getQuote(symbol);
                    long end = System.currentTimeMillis();
                    long respTime = end - start;
                    this.totResp += respTime;
                    ++this.numReqs;
                    ++this.numStatReqs;
                    if (respTime < minResp) {
                        ClientScenario.setMinResp(respTime);
                    }
                    if (respTime > maxResp) {
                        ClientScenario.setMaxResp(respTime);
                    }
                }
                catch (Exception e) {
                    System.out.println("Thread error -- scenario = xxx" + e.toString());
                    e.printStackTrace();
                    ++this.numErrs;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected long clearStats() {
        this.totResp = 0L;
        maxResp = 0L;
        minResp = Long.MAX_VALUE;
        this.totResp = 0L;
        this.numStatReqs = 0L;
        return this.numReqs;
    }

    protected static TradeWSServices getTrade() throws ServiceException, MalformedURLException {
        TradeWSServices trade;
        try {
            InitialContext context = new InitialContext();
            Trade tradeService1 = (Trade)context.lookup(jndiName);
            trade = tradeService1.getTradeWSServices();
        }
        catch (Exception e) {
            System.out.println("JSR 109 lookup failed .. defaulting to JSR 101");
            URL wsdlLoc = new URL(ClientScenario.getServicePort());
            QName serviceName = new QName("http://daytrader.samples.geronimo.apache.org", "Trade");
            Service tService = ServiceFactory.newInstance().createService(wsdlLoc, serviceName);
            QName portName = new QName("http://daytrader.samples.geronimo.apache.org", "TradeWSServices");
            trade = (TradeWSServices)tService.getPort(portName, TradeWSServices.class);
        }
        ((Stub)trade)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)ClientScenario.getServicePort());
        return trade;
    }

    public static TradeWSServices getTradeSingleton() throws Exception {
        if (tradeSingleton == null) {
            tradeSingleton = ClientScenario.getTrade();
        }
        return tradeSingleton;
    }

    public static long getIntervalStartTime() {
        return intervalStartTime;
    }

    public static long getMaxResp() {
        return maxResp;
    }

    public static long getMinResp() {
        return minResp;
    }

    public static long getNumThreads() {
        return numThreads;
    }

    public static long getReqPerThread() {
        return reqPerThread;
    }

    public static long getStartTime() {
        return startTime;
    }

    public static long getStatStartTime() {
        return statStartTime;
    }

    public static long getTotReqsAtLastInterval() {
        return totReqsAtLastInterval;
    }

    public long getNumErrs() {
        return this.numErrs;
    }

    public long getNumReqs() {
        return this.numReqs;
    }

    public boolean isStop() {
        return this.stop;
    }

    public long getTotResp() {
        return this.totResp;
    }

    public static void setIntervalStartTime(long intervalStartTime) {
        ClientScenario.intervalStartTime = intervalStartTime;
    }

    public static synchronized void setMaxResp(long maxResp) {
        ClientScenario.maxResp = maxResp;
    }

    public static synchronized void setMinResp(long minResp) {
        if (minResp > 0L) {
            ClientScenario.minResp = minResp;
        }
    }

    public static void setNumThreads(long numThreads) {
        ClientScenario.numThreads = numThreads;
    }

    public static void setReqPerThread(long reqPerThread) {
        ClientScenario.reqPerThread = reqPerThread;
    }

    public static void setStartTime(long startTime) {
        ClientScenario.startTime = startTime;
    }

    public static void setStatStartTime(long statStartTime) {
        ClientScenario.statStartTime = statStartTime;
    }

    public static void setTotReqsAtLastInterval(long totReqsAtLastInterval) {
        ClientScenario.totReqsAtLastInterval = totReqsAtLastInterval;
    }

    public void setNumErrs(long numErrs) {
        this.numErrs = numErrs;
    }

    public void setNumReqs(long numReqs) {
        this.numReqs = numReqs;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void setTotResp(long totResp) {
        this.totResp = totResp;
    }

    public static long getTotalNumRequests() {
        return numThreads * reqPerThread;
    }

    public long getNumStatReqs() {
        return this.numStatReqs;
    }

    public void setNumStatReqs(long numStatReqs) {
        this.numStatReqs = numStatReqs;
    }

    public static String getServicePort() {
        return servicePort;
    }

    public static void setServicePort(String servicePort) {
        ClientScenario.servicePort = servicePort;
        tradeSingleton = null;
    }

    static {
        startTime = 0L;
        statStartTime = 0L;
        intervalStartTime = 0L;
        totReqsAtLastInterval = 0L;
        minResp = Long.MAX_VALUE;
        maxResp = 0L;
        symbol = "s:1";
        tradeSingleton = null;
    }
}

