<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<form:form method="GET" modelAttribute="itemSearchCriteria">
	<fieldset>
		<legend>
			<spring:message code="book.searchcriteria" />
		</legend>
		<table>
			<tr>
				<td><form:label path="title">
						<spring:message code="book.title" />
					</form:label></td>
				<td><form:input path="title" /></td>
			</tr>
			<!-- 			<tr> -->
			<%-- 				<td><form:label path="category"> --%>
			<%-- 						<spring:message code="book.category" /> --%>
			<%-- 					</form:label></td> --%>
			<%-- 				<td><form:select path="category" items="${categories}" itemValue="id" itemLabel="name" /></td> --%>
			<!-- 			</tr> -->
		</table>
	</fieldset>
	<button id="search">
		<spring:message code="button.search" />
	</button>
</form:form>

<c:if test="${not empty itemList}">
	<table>
		<tr>
			<th><spring:message code="book.title" /></th>
			<th><spring:message code="book.description" /></th>
			<th><spring:message code="book.price" /></th>
			<th><spring:message code="book.category" /></th>
		</tr>
		<c:forEach items="${itemList}" var="item">
			<tr>
				<td><a href="<c:url value="/item/${item.id}"/>">${item.title}</a></td>
				<td>${item.description}</td>
				<td>${item.price}</td>
				<td>${item.category.name}</td>
			</tr>
		</c:forEach>
	</table>
</c:if>