/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.alfresco.healthprocessor.reporter.api;

import eu.xenit.alfresco.healthprocessor.extensibility.annotations.ExtensionType;
import eu.xenit.alfresco.healthprocessor.extensibility.annotations.InternalUseOnly;
import eu.xenit.alfresco.healthprocessor.extensibility.annotations.NotForUseIn;
import eu.xenit.alfresco.healthprocessor.extensibility.annotations.OnlyForUseIn;
import eu.xenit.alfresco.healthprocessor.reporter.api.NodeHealthStatus;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.alfresco.service.cmr.repository.NodeRef;

public final class NodeHealthReport
implements Serializable {
    private final NodeHealthStatus status;
    private final NodeRef nodeRef;
    private final Set<String> messages;
    private final Map<Class<?>, Set<?>> data = new HashMap();

    @OnlyForUseIn(value={ExtensionType.PROCESSOR})
    public NodeHealthReport(@Nonnull NodeHealthStatus status, @Nonnull NodeRef nodeRef) {
        this(status, nodeRef, Collections.emptySet());
    }

    @OnlyForUseIn(value={ExtensionType.PROCESSOR})
    public NodeHealthReport(@Nonnull NodeHealthStatus status, @Nonnull NodeRef nodeRef, String ... messages) {
        this(status, nodeRef, Arrays.asList(messages));
    }

    @OnlyForUseIn(value={ExtensionType.PROCESSOR})
    public NodeHealthReport(@Nonnull NodeHealthStatus status, @Nonnull NodeRef nodeRef, Collection<String> messages) {
        this(status, nodeRef, Collections.unmodifiableSet(new HashSet<String>(messages)));
    }

    public <T> Set<T> data(Class<T> clazz) {
        return this.data.computeIfAbsent(clazz, e -> new HashSet());
    }

    public Map<Class<?>, Set<?>> data() {
        return Collections.unmodifiableMap(this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue()))));
    }

    @NotForUseIn(value={ExtensionType.REPORTER})
    public void data(Map<Class<?>, Set<?>> data) {
        for (Map.Entry<Class<?>, Set<?>> entry : data.entrySet()) {
            this.data(entry.getKey()).addAll((Collection)entry.getValue());
        }
    }

    @InternalUseOnly
    public NodeHealthReport withoutUnpersistableData() {
        NodeHealthReport nodeHealthReport = new NodeHealthReport(this.status, this.nodeRef, this.messages);
        HashMap newData = new HashMap(this.data.size());
        for (Map.Entry<Class<?>, Set<?>> classSetEntry : this.data.entrySet()) {
            if (!PersistableData.class.isAssignableFrom(classSetEntry.getKey())) continue;
            newData.put(classSetEntry.getKey(), classSetEntry.getValue());
        }
        nodeHealthReport.data(newData);
        return nodeHealthReport;
    }

    @Generated
    public NodeHealthStatus getStatus() {
        return this.status;
    }

    @Generated
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Generated
    public Set<String> getMessages() {
        return this.messages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeHealthReport)) {
            return false;
        }
        NodeHealthReport other = (NodeHealthReport)o;
        NodeHealthStatus this$status = this.getStatus();
        NodeHealthStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        NodeRef this$nodeRef = this.getNodeRef();
        NodeRef other$nodeRef = other.getNodeRef();
        if (this$nodeRef == null ? other$nodeRef != null : !this$nodeRef.equals(other$nodeRef)) {
            return false;
        }
        Set<String> this$messages = this.getMessages();
        Set<String> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeHealthStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        NodeRef $nodeRef = this.getNodeRef();
        result = result * 59 + ($nodeRef == null ? 43 : $nodeRef.hashCode());
        Set<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NodeHealthReport(status=" + (Object)((Object)this.getStatus()) + ", nodeRef=" + this.getNodeRef() + ", messages=" + this.getMessages() + ")";
    }

    @Generated
    private NodeHealthReport(NodeHealthStatus status, NodeRef nodeRef, Set<String> messages) {
        this.status = status;
        this.nodeRef = nodeRef;
        this.messages = messages;
    }

    public static interface PersistableData
    extends Serializable {
    }
}

