/*
 * Decompiled with CFR 0.152.
 */
package eu.xenit.alfresco.healthprocessor.fixer.api;

import eu.xenit.alfresco.healthprocessor.extensibility.annotations.ExtensionType;
import eu.xenit.alfresco.healthprocessor.extensibility.annotations.InternalUseOnly;
import eu.xenit.alfresco.healthprocessor.extensibility.annotations.OnlyForUseIn;
import eu.xenit.alfresco.healthprocessor.fixer.api.NodeFixStatus;
import eu.xenit.alfresco.healthprocessor.reporter.api.NodeHealthReport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.alfresco.service.cmr.repository.NodeRef;

public final class NodeFixReport
implements NodeHealthReport.PersistableData {
    private final NodeFixStatus fixStatus;
    private final transient NodeHealthReport healthReport;
    private final Set<String> messages;
    @InternalUseOnly
    private final NodeRef nodeRef;

    @OnlyForUseIn(value={ExtensionType.FIXER})
    public NodeFixReport(@Nonnull NodeFixStatus status, @Nonnull NodeHealthReport healthReport) {
        this(status, healthReport, Collections.emptySet());
    }

    @OnlyForUseIn(value={ExtensionType.FIXER})
    public NodeFixReport(@Nonnull NodeFixStatus status, @Nonnull NodeHealthReport healthReport, String ... messages) {
        this(status, healthReport, Arrays.asList(messages));
    }

    @OnlyForUseIn(value={ExtensionType.FIXER})
    public NodeFixReport(@Nonnull NodeFixStatus status, @Nonnull NodeHealthReport healthReport, Collection<String> messages) {
        this(status, healthReport, new HashSet<String>(messages), healthReport.getNodeRef());
    }

    @Generated
    public NodeFixStatus getFixStatus() {
        return this.fixStatus;
    }

    @Generated
    public Set<String> getMessages() {
        return this.messages;
    }

    @Generated
    public String toString() {
        return "NodeFixReport(fixStatus=" + (Object)((Object)this.getFixStatus()) + ", healthReport=" + this.getHealthReport() + ", messages=" + this.getMessages() + ")";
    }

    @Generated
    private NodeFixReport(NodeFixStatus fixStatus, NodeHealthReport healthReport, Set<String> messages, NodeRef nodeRef) {
        this.fixStatus = fixStatus;
        this.healthReport = healthReport;
        this.messages = messages;
        this.nodeRef = nodeRef;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeFixReport)) {
            return false;
        }
        NodeFixReport other = (NodeFixReport)o;
        NodeFixStatus this$fixStatus = this.getFixStatus();
        NodeFixStatus other$fixStatus = other.getFixStatus();
        if (this$fixStatus == null ? other$fixStatus != null : !((Object)((Object)this$fixStatus)).equals((Object)other$fixStatus)) {
            return false;
        }
        Set<String> this$messages = this.getMessages();
        Set<String> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        NodeRef this$nodeRef = this.nodeRef;
        NodeRef other$nodeRef = other.nodeRef;
        return !(this$nodeRef == null ? other$nodeRef != null : !this$nodeRef.equals(other$nodeRef));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeFixStatus $fixStatus = this.getFixStatus();
        result = result * 59 + ($fixStatus == null ? 43 : ((Object)((Object)$fixStatus)).hashCode());
        Set<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        NodeRef $nodeRef = this.nodeRef;
        result = result * 59 + ($nodeRef == null ? 43 : $nodeRef.hashCode());
        return result;
    }

    @OnlyForUseIn(value={ExtensionType.FIXER})
    @Generated
    public NodeHealthReport getHealthReport() {
        return this.healthReport;
    }
}

