/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.botsing.preprocessing;

import eu.stamp.botsing.preprocessing.STProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class StackFlatten
implements STProcessor {
    static final String MORE = " more";
    protected static final String CAUSED_BY_PREFIX = "Caused by: ";
    private static StackFlatten instance = new StackFlatten();

    public static StackFlatten get() {
        return instance;
    }

    private StackFlatten() {
    }

    @Override
    public List<String> preprocess(List<String> lines, String regexp) {
        if (lines.size() < 2) {
            return lines;
        }
        List<List<String>> chuncks = this.splitLines(lines, CAUSED_BY_PREFIX);
        return this.flatten(chuncks, regexp);
    }

    List<String> cleanNestedChunk(List<String> chunk) throws IndexOutOfBoundsException {
        int size = chunk.size();
        chunk.set(0, chunk.get(0).replace(CAUSED_BY_PREFIX, ""));
        if (chunk.get(size - 1).endsWith(MORE)) {
            chunk.remove(size - 1);
        }
        return chunk;
    }

    List<String> flatten(List<List<String>> splittedTrace, String regexp) {
        Collections.reverse(splittedTrace);
        Pattern pattern = Pattern.compile(regexp);
        for (List<String> chunk : splittedTrace) {
            this.cleanNestedChunk(chunk);
            for (String line : chunk) {
                if (!pattern.matcher(line).find()) continue;
                return chunk;
            }
        }
        return Collections.emptyList();
    }

    List<List<String>> splitLines(List<String> lines, String prefix) {
        ArrayList<List<String>> subSets = new ArrayList<List<String>>();
        ArrayList<String> chunk = new ArrayList<String>();
        for (String line : lines) {
            if (line.startsWith(prefix)) {
                subSets.add(chunk);
                chunk = new ArrayList();
            }
            chunk.add(line);
        }
        subSets.add(chunk);
        return subSets;
    }
}

