/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.botsing.preprocessing;

import eu.stamp.botsing.preprocessing.ErrorMessage;
import eu.stamp.botsing.preprocessing.StackFlatten;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    public static Options options = Main.initOptions();
    private static String HYPHENS = "---";

    public static Options initOptions() {
        Options opt = new Options();
        Option flatten = new Option("f", "flatten", false, "use this option to flatten the stack trace");
        Option error = new Option("e", "error_message", false, "use this option to remove the error message");
        Option crash_log = new Option("i", "crash_log", true, "path to the input stack trace");
        Option output_log = new Option("o", "output_log", true, "path to the output stack trace after processing");
        Option source = new Option("p", "package", true, "regular expression package pointing to the classes of the project");
        crash_log.setRequired(true);
        output_log.setRequired(true);
        opt.addOption(crash_log);
        opt.addOption(output_log);
        opt.addOption(source);
        opt.addOption(flatten);
        opt.addOption(error);
        return opt;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Main.printOptions();
        }
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cli = parser.parse(options, args);
            boolean f = cli.hasOption('f');
            boolean e = cli.hasOption('e');
            String input = cli.getOptionValue('i');
            String output = cli.getOptionValue('o');
            String regexp = cli.getOptionValue('p');
            if (!f && !e) {
                System.out.println("Wrong arguments. No '-f' or '-e' flag selected");
                Main.printOptions();
            }
            if (f && regexp == null) {
                System.out.println("Wrong arguments. For '-f' flag, it's necessary to set the regexp with '-p'");
                Main.printOptions();
            }
            Main.preprocess(f, e, input, output, regexp);
        }
        catch (ParseException e) {
            System.out.println("Wrong arguments. " + e.getMessage());
            Main.printOptions();
        }
        catch (FileNotFoundException e) {
            System.out.println("Wrong arguments. " + e.getMessage());
            return;
        }
    }

    public static void preprocess(boolean flatten, boolean error, String input, String output, String regexp) throws FileNotFoundException {
        File inputFile = new File(input);
        if (!inputFile.exists()) {
            throw new FileNotFoundException("Input file name '" + inputFile + "' does not exist!");
        }
        File outFile = new File(output);
        if (outFile.exists()) {
            outFile.delete();
        }
        List<String> lines = Main.fileToLines(inputFile);
        if (flatten) {
            lines = StackFlatten.get().preprocess(lines, regexp);
        }
        if (error) {
            lines = ErrorMessage.get().preprocess(lines, null);
        }
        Main.linesToFile(lines, outFile);
        System.out.println("End pre-processing");
    }

    static List<String> fileToLines(File log) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(log));){
            boolean first = false;
            Iterator i = reader.lines().iterator();
            while (i.hasNext()) {
                String line = (String)i.next();
                if (line.startsWith(HYPHENS)) {
                    if (first) break;
                    first = true;
                    continue;
                }
                lines.add(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    static File linesToFile(List<String> lines, File out) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(out));){
            lines.forEach(l -> {
                try {
                    writer.write((String)l);
                    writer.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    static void printOptions() {
        Collection<Option> ops = options.getOptions();
        System.out.println("Available options are:");
        ops.forEach(ele -> {
            System.out.print("-" + ele.getOpt() + " " + ele.getLongOpt());
            if (ele.isRequired()) {
                System.out.print(" [required] ");
            } else {
                System.out.print(" [optional] ");
            }
            System.out.print("type: ");
            if (ele.hasArg()) {
                System.out.print("param");
            } else {
                System.out.print("flag");
            }
            System.out.println(", description: " + ele.getDescription());
        });
    }
}

