/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service.es;

import eu.scasefp7.assetregistry.data.Artefact;
import eu.scasefp7.assetregistry.data.PrivacyLevel;
import eu.scasefp7.assetregistry.data.Project;
import eu.scasefp7.assetregistry.dto.JsonProject;
import eu.scasefp7.assetregistry.dto.ProjectDTO;
import eu.scasefp7.assetregistry.service.ProjectService;
import eu.scasefp7.assetregistry.service.db.ProjectDbService;
import eu.scasefp7.assetregistry.service.es.AbstractEsServiceImpl;
import eu.scasefp7.assetregistry.service.es.ProjectEsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Local(value={ProjectEsService.class})
public class ProjectEsServiceImpl
extends AbstractEsServiceImpl<Project>
implements ProjectEsService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectEsServiceImpl.class);
    @EJB
    private ProjectDbService dbService;
    @EJB
    private ProjectService projectService;

    public List<ProjectDTO> find(String query) {
        SearchResponse response = this.getSearchResponse("project_index", "project", query);
        ArrayList<ProjectDTO> result = new ArrayList<ProjectDTO>();
        for (SearchHit hit : response.getHits().hits()) {
            String projectId = hit.getId();
            LOG.info("found {} because of {}", (Object)projectId, (Object)hit.getExplanation());
            Project project = (Project)this.dbService.find(new Long(projectId).longValue());
            if (null != project) {
                JsonProject jsonProject = this.projectService.convertEntityToJson(project);
                ProjectDTO dto = new ProjectDTO();
                dto.setProject(jsonProject);
                dto.setScore(hit.getScore());
                result.add(dto);
                continue;
            }
            LOG.warn("Project with id " + projectId + "could not be loaded");
        }
        return result;
    }

    public IndexResponse index(Project project) throws IOException {
        IndexResponse response = (IndexResponse)this.connectorService.getClient().prepareIndex("project_index", "project", project.getId().toString()).setSource(this.builder(project)).execute().actionGet();
        return response;
    }

    public UpdateResponse update(Project project) throws IOException {
        UpdateResponse response = (UpdateResponse)this.connectorService.getClient().prepareUpdate("project_index", "project", project.getId().toString()).setDoc(this.builder(project)).get();
        return response;
    }

    public UpdateResponse updatePrivacyLevel(long id, PrivacyLevel privacyLevel) throws IOException {
        UpdateResponse response = (UpdateResponse)this.connectorService.getClient().prepareUpdate("project_index", "project", new Long(id).toString()).setDoc(XContentFactory.jsonBuilder().startObject().field("privacy_level", (Object)privacyLevel).endObject()).get();
        return response;
    }

    private XContentBuilder builder(Project project) throws IOException {
        Object[] artefactIds = null;
        if (null != project.getArtefacts()) {
            artefactIds = new Long[project.getArtefacts().size()];
            List artefacts = project.getArtefacts();
            for (int i = 0; i < artefacts.size(); ++i) {
                artefactIds[i] = ((Artefact)artefacts.get(i)).getId();
            }
        }
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("name", project.getName()).field("privacy_level", (Object)project.getPrivacyLevel()).field("domain", null != project.getDomain() ? project.getDomain().getName() : null).field("subdomain", null != project.getSubDomain() ? project.getSubDomain().getName() : null).field("created_by", project.getCreatedBy()).field("updated_by", project.getUpdatedBy()).field("created_at", project.getCreatedAt()).field("updated_at", project.getUpdatedAt()).field("version", project.getVersion()).array("artefacts", artefactIds).endObject();
        return builder;
    }
}

