/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service.es;

import eu.scasefp7.assetregistry.data.Artefact;
import eu.scasefp7.assetregistry.dto.ArtefactDTO;
import eu.scasefp7.assetregistry.dto.JsonArtefact;
import eu.scasefp7.assetregistry.service.ArtefactService;
import eu.scasefp7.assetregistry.service.db.ArtefactDbService;
import eu.scasefp7.assetregistry.service.es.AbstractEsServiceImpl;
import eu.scasefp7.assetregistry.service.es.ArtefactEsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Local(value={ArtefactEsService.class})
public class ArtefactEsServiceImpl
extends AbstractEsServiceImpl<Artefact>
implements ArtefactEsService {
    private static final Logger LOG = LoggerFactory.getLogger(ArtefactEsServiceImpl.class);
    @EJB
    private ArtefactDbService dbService;
    @EJB
    private ArtefactService artefactService;

    public List<ArtefactDTO> find(String query) {
        SearchResponse response = this.getSearchResponse("artefact_index", "artefact", query);
        ArrayList<ArtefactDTO> result = new ArrayList<ArtefactDTO>();
        for (SearchHit hit : response.getHits().hits()) {
            Artefact artefact = (Artefact)this.dbService.find(Long.valueOf(hit.getId()).longValue());
            if (null != artefact) {
                ArtefactDTO dto = new ArtefactDTO();
                JsonArtefact jsonArtefact = this.artefactService.convertEntityToJson(artefact);
                dto.setArtefact(jsonArtefact);
                dto.setScore(hit.getScore());
                result.add(dto);
                continue;
            }
            LOG.warn("Artefact with id " + hit.getId() + "could not be loaded");
        }
        return result;
    }

    public IndexResponse index(Artefact artefact) throws IOException {
        Client client = this.connectorService.getClient();
        String string = artefact.getId().toString();
        IndexRequestBuilder prepareIndex = client.prepareIndex("artefact_index", "artefact", string);
        XContentBuilder builder = this.builder(artefact);
        IndexRequestBuilder setSource = prepareIndex.setSource(builder);
        ListenableActionFuture execute = setSource.execute();
        IndexResponse response = (IndexResponse)execute.actionGet();
        return response;
    }

    public UpdateResponse update(Artefact artefact) throws IOException {
        UpdateResponse response = (UpdateResponse)this.connectorService.getClient().prepareUpdate("artefact_index", "artefact", artefact.getId().toString()).setDoc(this.builder(artefact)).get();
        return response;
    }

    private XContentBuilder builder(Artefact artefact) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("name", artefact.getName()).field("privacy_level", (Object)artefact.getPrivacyLevel()).field("created_by", artefact.getCreatedBy()).field("updated_by", artefact.getUpdatedBy()).field("created_at", artefact.getCreatedBy()).field("updated_at", artefact.getUpdatedAt()).field("version", artefact.getVersion()).field("projectname", artefact.getProjectName()).field("uri", artefact.getUri()).field("groupid", artefact.getGroupId()).array("dependencies", (Object[])artefact.getDependencies().toArray(new Long[artefact.getDependencies().size()])).field("artefact_type", (Object)artefact.getType()).field("description", artefact.getDescription()).array("tags", artefact.getTags().toArray(new String[artefact.getTags().size()])).field("metadata", (Object)artefact.getMetadata()).field("domain", null != artefact.getDomain() ? artefact.getDomain().getName() : null).field("subdomain", null != artefact.getSubDomain() ? artefact.getSubDomain().getName() : null).endObject();
        return builder;
    }
}

