/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service.db;

import eu.scasefp7.assetregistry.data.Project;
import eu.scasefp7.assetregistry.service.db.BaseCrudDbServiceImpl;
import eu.scasefp7.assetregistry.service.db.ProjectDbService;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
@Local(value={ProjectDbService.class})
public class ProjectDbServiceImpl
extends BaseCrudDbServiceImpl<Project>
implements ProjectDbService {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    Class<Project> getEntityClass() {
        return Project.class;
    }

    public Project findByName(String name) {
        TypedQuery query = this.entityManager.createQuery("SELECT p FROM Project p WHERE p.name = :name", Project.class).setParameter("name", (Object)name);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return (Project)result.get(0);
    }

    public Project update(Project entity) {
        Project loaded = (Project)this.find(entity.getId());
        this.validateVersion(loaded, entity);
        loaded.setName(entity.getName());
        loaded.setPrivacyLevel(entity.getPrivacyLevel());
        loaded.setDomain(entity.getDomain());
        loaded.setSubDomain(entity.getSubDomain());
        loaded.setUpdatedAt(new Date());
        loaded.setArtefacts(entity.getArtefacts());
        Project updated = (Project)this.entityManager.merge((Object)loaded);
        return updated;
    }

    @Override
    protected EntityManager em() {
        return this.entityManager;
    }
}

