/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service.db;

import eu.scasefp7.assetregistry.data.Domain;
import eu.scasefp7.assetregistry.data.SubDomain;
import eu.scasefp7.assetregistry.service.db.DomainDbService;
import eu.scasefp7.assetregistry.service.exception.NameNotFoundException;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

@Stateless
public class DomainDbServiceImpl
implements DomainDbService {
    @PersistenceContext
    private EntityManager entityManager;

    public Domain findDomain(long domainId) {
        return (Domain)this.em().find(Domain.class, (Object)domainId);
    }

    public Domain findDomainByName(String name) {
        TypedQuery query = this.entityManager.createQuery("SELECT d FROM Domain d WHERE d.name = :name", Domain.class).setParameter("name", (Object)name);
        List result = query.getResultList();
        if (result.isEmpty()) {
            throw new NameNotFoundException(Domain.class, name);
        }
        return (Domain)result.get(0);
    }

    public SubDomain findSubDomain(long subdomainId) {
        return (SubDomain)this.em().find(SubDomain.class, (Object)subdomainId);
    }

    public SubDomain findSubDomainByName(String name) {
        TypedQuery query = this.entityManager.createQuery("SELECT s FROM SubDomain s WHERE s.name = :name", SubDomain.class).setParameter("name", (Object)name);
        List result = query.getResultList();
        if (result.isEmpty()) {
            throw new NameNotFoundException(SubDomain.class, name);
        }
        return (SubDomain)result.get(0);
    }

    public List<Domain> findAllDomains() {
        CriteriaBuilder cb = this.em().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Domain.class);
        cq.from(Domain.class);
        return this.em().createQuery(cq).getResultList();
    }

    public List<SubDomain> findAllSubDomains() {
        CriteriaBuilder cb = this.em().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(SubDomain.class);
        cq.from(SubDomain.class);
        return this.em().createQuery(cq).getResultList();
    }

    private EntityManager em() {
        return this.entityManager;
    }
}

