/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service.db;

import eu.scasefp7.assetregistry.data.BaseEntity;
import eu.scasefp7.assetregistry.service.db.BaseCrudDbService;
import eu.scasefp7.assetregistry.service.exception.NotFoundException;
import eu.scasefp7.base.ScaseException;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

abstract class BaseCrudDbServiceImpl<E extends BaseEntity>
implements BaseCrudDbService<E> {
    public static final int MAX_RESULTS = 5000;

    BaseCrudDbServiceImpl() {
    }

    abstract Class<E> getEntityClass();

    public E create(E entity) {
        if (entity.getId() == null) {
            entity.setCreatedAt(new Date());
            this.em().persist(entity);
            return entity;
        }
        throw new IllegalStateException("id must not be set");
    }

    public void delete(E entity) {
        if (this.countUsed(entity) > 0L) {
            throw new ScaseException("Could not delete " + this.getEntityClass().getSimpleName());
        }
        this.em().remove(entity);
    }

    public void delete(long entityId) {
        E e = this.find(entityId);
        if (e == null) {
            throw new NotFoundException(this.getEntityClass(), entityId);
        }
        this.delete(e);
    }

    public E find(long id) {
        return (E)((BaseEntity)this.em().find(this.getEntityClass(), (Object)id));
    }

    public List<E> findAll() {
        CriteriaBuilder cb = this.em().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.getEntityClass());
        cq.from(this.getEntityClass());
        return this.em().createQuery(cq).setMaxResults(5000).getResultList();
    }

    protected abstract EntityManager em();

    public Long countUsed(E e) {
        return 0L;
    }

    public E createOrUpdate(E e) {
        if (e.getId() == null) {
            return this.create(e);
        }
        return (E)this.update((BaseEntity)e);
    }

    public void validateVersion(E loaded, E external) {
        if (loaded.getVersion() > external.getVersion()) {
            throw new OptimisticLockException(loaded.getClass().getSimpleName());
        }
    }
}

