/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service;

import eu.scasefp7.assetregistry.data.Artefact;
import eu.scasefp7.assetregistry.data.BaseEntity;
import eu.scasefp7.assetregistry.data.Project;
import eu.scasefp7.assetregistry.dto.JsonArtefact;
import eu.scasefp7.assetregistry.dto.JsonProject;
import eu.scasefp7.assetregistry.dto.ProjectDTO;
import eu.scasefp7.assetregistry.service.ArtefactService;
import eu.scasefp7.assetregistry.service.ProjectService;
import eu.scasefp7.assetregistry.service.db.DomainDbService;
import eu.scasefp7.assetregistry.service.db.ProjectDbService;
import eu.scasefp7.assetregistry.service.es.ProjectEsService;
import eu.scasefp7.assetregistry.service.exception.NameNotFoundException;
import eu.scasefp7.assetregistry.service.exception.NotCreatedException;
import eu.scasefp7.assetregistry.service.exception.NotUpdatedException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Local(value={ProjectService.class})
public class ProjectServiceImpl
implements ProjectService {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @EJB
    private ProjectDbService dbService;
    @EJB
    private DomainDbService domainDbService;
    @EJB
    private ArtefactService artefactService;
    @EJB
    private ProjectEsService esService;

    public Project find(long id) {
        Project project = (Project)this.dbService.find(id);
        return project;
    }

    public Project findByName(String name) {
        Project project = this.dbService.findByName(name);
        return project;
    }

    public List<ProjectDTO> find(String query) {
        List projects = this.esService.find(query);
        return projects;
    }

    public Project create(Project project) {
        try {
            project = (Project)this.dbService.create((BaseEntity)project);
            this.esService.index((BaseEntity)project);
        }
        catch (Throwable thrown) {
            throw new NotCreatedException(Project.class, project.getId().longValue(), thrown);
        }
        return project;
    }

    public Project update(Project project) {
        try {
            project = this.dbService.update(project);
            this.esService.update((BaseEntity)project);
        }
        catch (Throwable thrown) {
            throw new NotUpdatedException(Project.class, project.getId().longValue(), thrown);
        }
        return project;
    }

    public void delete(long id) {
        this.esService.delete(id, "project_index", "project");
        this.dbService.delete(id);
    }

    public void delete(String name) {
        Project project = null;
        try {
            long id = Long.parseLong(name);
            project = (Project)this.dbService.find(id);
        }
        catch (NumberFormatException e) {
            LOG.warn("Value " + name + " could not be parsed into a number. Trying to find the project by name.");
            project = this.dbService.findByName(name);
        }
        if (null == project) {
            throw new NameNotFoundException(Project.class, name);
        }
        this.delete(project.getId());
    }

    public void delete(Project project) {
        this.esService.delete((BaseEntity)project, "project_index", "project");
        this.dbService.delete((BaseEntity)project);
    }

    public Project convertJsonToEntity(JsonProject jsonProject) {
        Project project = new Project();
        project.setId(jsonProject.getId());
        project.setCreatedAt(jsonProject.getCreatedAt());
        project.setCreatedBy(jsonProject.getCreatedBy());
        project.setUpdatedAt(jsonProject.getUpdatedAt());
        project.setUpdatedBy(jsonProject.getUpdatedBy());
        project.setVersion(jsonProject.getVersion());
        if (null != jsonProject.getDomain()) {
            this.domainDbService.findDomainByName(jsonProject.getDomain());
        }
        if (null != jsonProject.getSubDomain()) {
            this.domainDbService.findSubDomainByName(jsonProject.getSubDomain());
        }
        project.setName(jsonProject.getName());
        project.setPrivacyLevel(jsonProject.getPrivacyLevel());
        if (null != jsonProject.getArtefacts()) {
            List jsonArtefacts = jsonProject.getArtefacts();
            for (JsonArtefact jsonArtefact : jsonArtefacts) {
                Artefact artefact = this.artefactService.convertJsonToEntity(jsonArtefact);
                project.getArtefacts().add(artefact);
            }
        }
        return project;
    }

    public JsonProject convertEntityToJson(Project project) {
        JsonProject jsonProject = new JsonProject();
        jsonProject.setId(project.getId());
        jsonProject.setCreatedAt(project.getCreatedAt());
        jsonProject.setCreatedBy(project.getCreatedBy());
        jsonProject.setUpdatedAt(project.getUpdatedAt());
        jsonProject.setUpdatedBy(project.getUpdatedBy());
        jsonProject.setVersion(project.getVersion());
        if (null != project.getDomain()) {
            jsonProject.setDomain(project.getDomain().getName());
        }
        if (null != project.getSubDomain()) {
            jsonProject.setSubDomain(project.getSubDomain().getName());
        }
        jsonProject.setName(project.getName());
        jsonProject.setPrivacyLevel(project.getPrivacyLevel());
        if (null != project.getArtefacts()) {
            List artefacts = project.getArtefacts();
            for (Artefact artefact : artefacts) {
                JsonArtefact jsonArtefact = this.artefactService.convertEntityToJson(artefact);
                jsonProject.getArtefacts().add(jsonArtefact);
            }
        }
        return jsonProject;
    }
}

