/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.service;

import eu.scasefp7.assetregistry.data.Artefact;
import eu.scasefp7.assetregistry.data.ArtefactPayload;
import eu.scasefp7.assetregistry.data.BaseEntity;
import eu.scasefp7.assetregistry.dto.ArtefactDTO;
import eu.scasefp7.assetregistry.dto.JsonArtefact;
import eu.scasefp7.assetregistry.dto.JsonArtefactPayload;
import eu.scasefp7.assetregistry.service.ArtefactService;
import eu.scasefp7.assetregistry.service.db.ArtefactDbService;
import eu.scasefp7.assetregistry.service.db.DomainDbService;
import eu.scasefp7.assetregistry.service.es.ArtefactEsService;
import eu.scasefp7.assetregistry.service.exception.NotCreatedException;
import eu.scasefp7.assetregistry.service.exception.NotUpdatedException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;

@Stateless
@Local(value={ArtefactService.class})
public class ArtefactServiceImpl
implements ArtefactService {
    @EJB
    private ArtefactDbService dbService;
    @EJB
    private ArtefactEsService esService;
    @EJB
    private DomainDbService domainDbService;

    public Artefact find(long id) {
        Artefact artefact = (Artefact)this.dbService.find(id);
        return artefact;
    }

    public List<ArtefactDTO> find(String query) {
        List artefacts = this.esService.find(query);
        return artefacts;
    }

    public Artefact create(Artefact artefact) {
        Artefact create;
        try {
            create = (Artefact)this.dbService.create((BaseEntity)artefact);
        }
        catch (Throwable thrown) {
            throw new NotCreatedException(Artefact.class, 0L, thrown);
        }
        try {
            this.esService.index((BaseEntity)create);
        }
        catch (Throwable thrown) {
            throw new NotCreatedException(Artefact.class, artefact.getId().longValue(), thrown);
        }
        return create;
    }

    public Artefact update(Artefact artefact) {
        try {
            artefact = this.dbService.update(artefact);
            this.esService.update((BaseEntity)artefact);
        }
        catch (Throwable thrown) {
            throw new NotUpdatedException(Artefact.class, artefact.getId().longValue(), thrown);
        }
        return artefact;
    }

    public void delete(long id) {
        this.esService.delete(id, "artefact_index", "artefact");
        this.dbService.delete(id);
    }

    public void delete(Artefact artefact) {
        this.esService.delete((BaseEntity)artefact, "artefact_index", "artefact");
        this.dbService.delete((BaseEntity)artefact);
    }

    public Artefact convertJsonToEntity(JsonArtefact jsonArtefact) {
        Artefact artefact = new Artefact();
        artefact.setId(jsonArtefact.getId());
        artefact.setCreatedAt(jsonArtefact.getCreatedAt());
        artefact.setCreatedBy(jsonArtefact.getCreatedBy());
        artefact.setUpdatedAt(jsonArtefact.getUpdatedAt());
        artefact.setUpdatedBy(jsonArtefact.getUpdatedBy());
        artefact.setVersion(jsonArtefact.getVersion());
        if (null != jsonArtefact.getDomain()) {
            this.domainDbService.findDomainByName(jsonArtefact.getDomain());
        }
        if (null != jsonArtefact.getSubDomain()) {
            this.domainDbService.findSubDomainByName(jsonArtefact.getSubDomain());
        }
        artefact.setName(jsonArtefact.getName());
        artefact.setPrivacyLevel(jsonArtefact.getPrivacyLevel());
        artefact.setUri(jsonArtefact.getUri());
        artefact.setGroupId(jsonArtefact.getGroupId());
        artefact.setDependencies(jsonArtefact.getDependencies());
        artefact.setType(jsonArtefact.getType());
        artefact.setTags(jsonArtefact.getTags());
        artefact.setMetadata(jsonArtefact.getMetadata());
        artefact.setDescription(jsonArtefact.getDescription());
        for (JsonArtefactPayload jsonPayload : jsonArtefact.getPayload()) {
            ArtefactPayload payload = this.convertJsonToEntity(jsonPayload);
            artefact.getPayload().add(payload);
        }
        return artefact;
    }

    public JsonArtefact convertEntityToJson(Artefact artefact) {
        JsonArtefact jsonArtefact = new JsonArtefact();
        jsonArtefact.setId(artefact.getId());
        jsonArtefact.setCreatedAt(artefact.getCreatedAt());
        jsonArtefact.setCreatedBy(artefact.getCreatedBy());
        jsonArtefact.setUpdatedAt(artefact.getUpdatedAt());
        jsonArtefact.setUpdatedBy(artefact.getUpdatedBy());
        jsonArtefact.setVersion(artefact.getVersion());
        if (null != artefact.getDomain()) {
            jsonArtefact.setDomain(artefact.getDomain().getName());
        }
        if (null != artefact.getSubDomain()) {
            jsonArtefact.setSubDomain(artefact.getSubDomain().getName());
        }
        jsonArtefact.setName(artefact.getName());
        jsonArtefact.setProjectName(artefact.getProjectName());
        jsonArtefact.setPrivacyLevel(artefact.getPrivacyLevel());
        jsonArtefact.setUri(artefact.getUri());
        jsonArtefact.setGroupId(artefact.getGroupId());
        jsonArtefact.setDependencies(artefact.getDependencies());
        jsonArtefact.setType(artefact.getType());
        jsonArtefact.setTags(artefact.getTags());
        jsonArtefact.setMetadata(artefact.getMetadata());
        jsonArtefact.setDescription(artefact.getDescription());
        for (ArtefactPayload payload : artefact.getPayload()) {
            JsonArtefactPayload jsonArtefactPayload = this.convertEntityToJson(payload);
            jsonArtefact.getPayload().add(jsonArtefactPayload);
        }
        return jsonArtefact;
    }

    private JsonArtefactPayload convertEntityToJson(ArtefactPayload payload) {
        JsonArtefactPayload jsonPayload = new JsonArtefactPayload();
        jsonPayload.setId(payload.getId());
        jsonPayload.setName(payload.getName());
        jsonPayload.setFormat(payload.getFormat());
        jsonPayload.setType(payload.getType());
        jsonPayload.setPayload(payload.getPayload());
        jsonPayload.setVersion(payload.getVersion());
        return jsonPayload;
    }

    private ArtefactPayload convertJsonToEntity(JsonArtefactPayload jsonPayload) {
        ArtefactPayload payload = new ArtefactPayload();
        payload.setId(jsonPayload.getId());
        payload.setName(jsonPayload.getName());
        payload.setFormat(jsonPayload.getFormat());
        payload.setType(jsonPayload.getType());
        payload.setPayload(jsonPayload.getPayload());
        payload.setVersion(jsonPayload.getVersion());
        return payload;
    }
}

