/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.rest;

import eu.scasefp7.assetregistry.data.BaseEntity;
import eu.scasefp7.assetregistry.data.Project;
import eu.scasefp7.assetregistry.dto.JsonProject;
import eu.scasefp7.assetregistry.dto.ProjectDTO;
import eu.scasefp7.assetregistry.rest.ResourceTools;
import eu.scasefp7.assetregistry.service.ProjectService;
import java.net.URISyntaxException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/project/")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json"})
@Stateless
public class ProjectResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectResource.class);
    @EJB
    private ProjectService projectService;

    @GET
    @Path(value="{id}")
    public JsonProject get(@PathParam(value="id") long id) {
        Project projectEntity = this.projectService.find(id);
        JsonProject jsonProject = this.projectService.convertEntityToJson(projectEntity);
        return jsonProject;
    }

    @GET
    @Path(value="{name}")
    public JsonProject get(@PathParam(value="name") String name) {
        Project projectEntity = this.projectService.findByName(name);
        JsonProject jsonProject = this.projectService.convertEntityToJson(projectEntity);
        return jsonProject;
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProjectDTO> searchProjects(@QueryParam(value="q") String query) {
        LOG.info("search '{}'", (Object)query);
        List projects = this.projectService.find(query);
        return projects;
    }

    @POST
    public Response create(JsonProject project) throws URISyntaxException {
        Project projectEntity = this.projectService.convertJsonToEntity(project);
        Project created = this.projectService.create(projectEntity);
        return ResourceTools.redirect("project/" + created.getId());
    }

    @PUT
    @Path(value="{id}")
    public Response update(@PathParam(value="id") long id, JsonProject project) throws URISyntaxException {
        project.setId(Long.valueOf(id));
        Project projectEntity = this.projectService.convertJsonToEntity(project);
        Project updated = this.projectService.update(projectEntity);
        return ResourceTools.redirect("project/", (BaseEntity)updated);
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") long id) {
        this.projectService.delete(id);
    }

    @DELETE
    @Path(value="{name}")
    public void delete(@PathParam(value="name") String name) {
        this.projectService.delete(name);
    }
}

