/*
 * Decompiled with CFR 0.152.
 */
package eu.scasefp7.assetregistry.rest;

import eu.scasefp7.assetregistry.data.Artefact;
import eu.scasefp7.assetregistry.data.BaseEntity;
import eu.scasefp7.assetregistry.data.Project;
import eu.scasefp7.assetregistry.dto.ArtefactDTO;
import eu.scasefp7.assetregistry.dto.JsonArtefact;
import eu.scasefp7.assetregistry.rest.ResourceTools;
import eu.scasefp7.assetregistry.service.ArtefactService;
import eu.scasefp7.assetregistry.service.ProjectService;
import java.net.URISyntaxException;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/artefact/")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json"})
@Stateless
public class ArtefactResource {
    private static final Logger LOG = LoggerFactory.getLogger(ArtefactResource.class);
    @EJB
    private ArtefactService artefactService;
    @EJB
    private ProjectService projectService;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public JsonArtefact get(@PathParam(value="id") long id) {
        Artefact artefactEntity = this.artefactService.find(id);
        JsonArtefact jsonArtefact = this.artefactService.convertEntityToJson(artefactEntity);
        return jsonArtefact;
    }

    @GET
    @Path(value="exists/{id}")
    @Produces(value={"application/json"})
    public boolean exists(@PathParam(value="id") long id) {
        return null != this.artefactService.find(id);
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    public List<ArtefactDTO> searchArtefacts(@QueryParam(value="q") String query) {
        LOG.info("search '{}'", (Object)query);
        List artefacts = this.artefactService.find(query);
        return artefacts;
    }

    @POST
    public Response create(JsonArtefact artefact) throws URISyntaxException {
        Project project = this.projectService.findByName(artefact.getProjectName());
        if (null == project) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Project with ID" + artefact.getProjectName() + " could not be found inside of the Artefact Repository")).build();
        }
        Artefact artefactEntity = this.artefactService.convertJsonToEntity(artefact);
        Artefact created = this.artefactService.create(artefactEntity);
        project.getArtefacts().add(created);
        this.projectService.update(project);
        return ResourceTools.redirect("artefact/" + created.getId());
    }

    @PUT
    @Path(value="{id}")
    public Response update(@PathParam(value="id") long id, JsonArtefact artefact) throws URISyntaxException {
        artefact.setId(Long.valueOf(id));
        Artefact artefactEntity = this.artefactService.convertJsonToEntity(artefact);
        Artefact updated = this.artefactService.update(artefactEntity);
        return ResourceTools.redirect("artefact/", (BaseEntity)updated);
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") long id) {
        this.artefactService.delete(id);
    }
}

