package eu.codlab.compose.theme

import androidx.compose.material3.ColorScheme
import androidx.compose.material3.Shapes
import androidx.compose.material3.Typography
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

private val fullBlack = AppColor.Black
private val unselected = Color(0xff7a6b63)
private val selected = Color(0xffeec788)

private val colorNavigationsDark = ColorBottomNavigations(
    background = fullBlack,
    unselected = unselected,
    selected = selected
)

data class Material(
    val colors: ColorScheme,
    val typography: Typography,
    val shapes: Shapes
)

data class ThemeEnvironment(
    // material stuff
    val material: Material? = null,

    // custom
    val defaultPadding: Dp = 16.dp,
    val navigationColors: ColorBottomNavigations = colorNavigationsDark,
    val colors: ColorTheme = ColorTheme(
        graySemiTransparent = AppColor.GraySemiTransparentDark
    ),
    val gradientStart: Color = AppColor.Violet,
    val gradientEnd: Color = AppColor.Blue
)
