package eu.codlab.compose.widgets

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.dp
import eu.codlab.compose.theme.LocalDarkTheme

@Composable
fun TransparentIconButton(
    modifier: Modifier = Modifier,
    onClick: () -> Unit,
    imageVector: ImageVector,
    color: Color? = null
) {
    // TODO getting the color from local context
    val newColor = color
        ?: if (LocalDarkTheme.current) {
            Color.White
        } else {
            Color.Black
        }

    TextButton(
        modifier = modifier,
        onClick = onClick,
        contentPadding = PaddingValues(0.dp)
    ) {
        Image(
            modifier = modifier,
            imageVector = imageVector,
            contentDescription = null,
            colorFilter = ColorFilter.tint(
                color = newColor
            )
        )
    }
}

@Composable
fun TransparentIconButton(
    modifier: Modifier = Modifier,
    onClick: () -> Unit,
    fontFamily: FontFamily,
    text: String,
    color: Color? = null,
    fontSize: TextUnit = TextUnit.Unspecified
) {
    // TODO getting the color from local context
    val newColor = color
        ?: if (LocalDarkTheme.current) {
            Color.White
        } else {
            Color.Black
        }

    TextButton(
        modifier = modifier,
        onClick = onClick,
        contentPadding = PaddingValues(0.dp)
    ) {
        Text(
            fontSize = fontSize,
            color = newColor,
            text = text,
            fontFamily = fontFamily
        )
    }
}
