package eu.codlab.compose.widgets

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.height
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.dp
import eu.codlab.safearea.views.topBar

@Composable
fun TopSpacer(color: Color = Color.Transparent) {
    val height = WindowInsets.topBar.getTop(LocalDensity.current)
    val scaled = height / LocalDensity.current.density

    Spacer(
        modifier = Modifier
            .background(color = color)
            .height(scaled.dp)
    )
}
