package eu.codlab.compose.widgets.screen

import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

enum class WindowType {
    SMARTPHONE_TINY,
    SMARTPHONE,
    TABLET;

    // Factory method that creates an instance of the class based on window width
    companion object {
        fun basedOnWidth(windowWidth: Dp): WindowType {
            return when {
                windowWidth < 250.dp -> SMARTPHONE_TINY
                windowWidth < 400.dp -> SMARTPHONE
                else -> TABLET
            }
        }
    }
}
