package eu.codlab.compose.widgets

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.BoxScope
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.runtime.compositionLocalOf
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.onGloballyPositioned
import androidx.compose.ui.platform.LocalDensity
import eu.codlab.compose.widgets.screen.WindowType

val LocalWindow = compositionLocalOf { WindowType.TABLET }

@Composable
fun CompositionScreenProvider(
    modifier: Modifier = Modifier,
    content: @Composable BoxScope.() -> Unit
) {
    var window by remember { mutableStateOf(WindowType.TABLET) }
    val localDensity = LocalDensity.current

    CompositionLocalProvider(
        LocalWindow provides window
    ) {
        Box(
            modifier = modifier
                .onGloballyPositioned { coordinates ->
                    val width = with(localDensity) { coordinates.size.width.toDp() }

                    val newWindowSize = WindowType.basedOnWidth(width)

                    if (newWindowSize != window) {
                        window = newWindowSize
                    }
                },
            content = content
        )
    }
}