package eu.codlab.openweathermap.calls

import eu.codlab.openweathermap.rest.RestOptions
import io.ktor.client.request.get
import kotlinx.serialization.KSerializer

class RestApi30(options: RestOptions) : InternalRestClient(options) {
    private val url: String = "https://api.openweathermap.org/data/3.0/onecall"

    suspend fun <O> call(
        params: Map<String, String>,
        deserializer: KSerializer<O>
    ): O? {
        val query = params.entries.joinToString("&") { "${it.key}=${it.value}" }
        val mandatory = "units=${options.units}&APPID=${options.apiKey}"

        val response = client.get("$url?$mandatory&$query")

        return map(response, deserializer)
    }
}
