package eu.codlab.openweathermap

import eu.codlab.openweathermap.calls.RestApiPublic
import eu.codlab.openweathermap.models.api2.WeatherData
import eu.codlab.openweathermap.rest.RestOptions

class Api2(
    apiKey: String,
    units: String,
    enableHttpLogs: Boolean = false
) {
    private val call = RestApiPublic(
        RestOptions(
            apiKey = apiKey,
            units = units,
            enableHttpLogs = enableHttpLogs
        )
    )

    suspend fun currentWeatherForCity(cityName: String) = call.call(
        mapOf("q" to cityName),
        WeatherData.serializer()
    )

    suspend fun currentWeatherForCityId(cityId: String) = call.call(
        mapOf("id" to cityId),
        WeatherData.serializer()
    )

    suspend fun currentWeatherForPosition(latitude: Double, longitude: Double) = call.call(
        mapOf(
            "lat" to "$latitude",
            "lon" to "$longitude"
        ),
        WeatherData.serializer()
    )
}