@file:Suppress("ktlint:filename")

package eu.codlab.moko.ext

import dev.icerock.moko.resources.FileResource
import platform.Foundation.NSBundle
import platform.darwin.NSObject
import platform.darwin.NSObjectMeta

actual fun FileResource.readContentOrSafe(): String? {
    @Suppress("TooGenericExceptionCaught", "PrintStackTrace")
    return try {
        val reader = ResourceReader()
        val bundle = NSBundle.bundleForClass(BundleMarker)

        val path = "Frameworks/resources.framework/${this.bundle.bundleIdentifier}:" +
                "resources.bundle/Contents/Resources/files"

        reader.readResource(bundle, "${this.fileName}.${this.extension}", path)
    } catch (e: Throwable) {
        println("exception in readContentSafe() $e")
        e.printStackTrace()
        null
    }
}

@Suppress("UnusedPrivateClass")
private class BundleMarker : NSObject() {
    companion object : NSObjectMeta()
}
