/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.pui9;

import es.prodevelop.pui9.eventlistener.ThreadDaoEvents;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class PuiTransactionManager
extends DataSourceTransactionManager {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong seq = new AtomicLong(0L);
    @Autowired
    private ThreadDaoEvents threadDaoEvents;

    public PuiTransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    protected Object doGetTransaction() {
        Object obj = super.doGetTransaction();
        this.threadDaoEvents.initialize();
        return obj;
    }

    protected void doCommit(DefaultTransactionStatus status) {
        super.doCommit(status);
        this.threadDaoEvents.process(seq.getAndIncrement());
    }

    protected void doRollback(DefaultTransactionStatus status) {
        super.doRollback(status);
        this.threadDaoEvents.remove();
    }
}

