/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.generator.layers;

import es.prodevelop.pui9.classpath.PuiDynamicClassLoader;
import es.prodevelop.pui9.model.dao.interfaces.IDao;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.generator.TemplateFileInfo;
import es.prodevelop.pui9.model.generator.layers.AbstractLayerGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;
import org.springframework.util.StringUtils;

public abstract class AbstractDaoLayerGenerator
extends AbstractLayerGenerator {
    public static final String subpackageTableName = ".model.dto";
    public static final String subpackageTableInterfacesName = ".model.dto.interfaces";
    public static final String subpackageViewName = ".model.views.dto";
    public static final String subpackageViewInterfacesName = ".model.views.dto.interfaces";

    @Override
    public List<TemplateFileInfo> getTemplateList(boolean isView) {
        ArrayList<TemplateFileInfo> tableTemplateList = new ArrayList<TemplateFileInfo>();
        if (!isView) {
            tableTemplateList.addAll(this.getTableDtoTemplates());
            tableTemplateList.addAll(this.getTableDaoTemplates());
        } else {
            tableTemplateList.addAll(this.getViewDtoTemplates());
            tableTemplateList.addAll(this.getViewDaoTemplates());
        }
        return tableTemplateList;
    }

    protected List<TemplateFileInfo> getTableDtoTemplates() {
        TemplateFileInfo idtopk = new TemplateFileInfo("dto/ITableDtoPk.ftl", "I%filename%Pk" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.dto.interfaces");
        TemplateFileInfo idto = new TemplateFileInfo("dto/ITableDto.ftl", "I%filename%" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.dto.interfaces");
        TemplateFileInfo dtopk = new TemplateFileInfo("dto/TableDtoPk.ftl", "%filename%Pk" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.dto");
        TemplateFileInfo dto = new TemplateFileInfo("dto/TableDto.ftl", "%filename%" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.dto");
        ArrayList<TemplateFileInfo> list = new ArrayList<TemplateFileInfo>();
        list.add(idtopk);
        list.add(idto);
        list.add(dtopk);
        list.add(dto);
        return list;
    }

    protected List<TemplateFileInfo> getViewDtoTemplates() {
        TemplateFileInfo idto = new TemplateFileInfo("dto/IViewDto.ftl", "I%filename%" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.views.dto.interfaces");
        TemplateFileInfo dto = new TemplateFileInfo("dto/ViewDto.ftl", "%filename%" + JavaFileObject.Kind.SOURCE.extension, "es.prodevelop.pui9.generated.model.views.dto");
        ArrayList<TemplateFileInfo> list = new ArrayList<TemplateFileInfo>();
        list.add(idto);
        list.add(dto);
        return list;
    }

    protected abstract List<TemplateFileInfo> getTableDaoTemplates();

    protected abstract List<TemplateFileInfo> getViewDaoTemplates();

    @Override
    protected List<Class<?>> getClassesToRegister(List<TemplateFileInfo> templateList) throws Exception {
        ArrayList classes = new ArrayList();
        for (TemplateFileInfo tfi : templateList) {
            String className = (tfi.getPackageName() + "." + tfi.getFileName()).replace(JavaFileObject.Kind.SOURCE.extension, "");
            Class clazz = PuiDynamicClassLoader.getInstance().loadClass(className);
            if (!IDao.class.isAssignableFrom(clazz) || !this.classPassFilter(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    @Override
    protected Object registerBean(Class<?> clazz) {
        this.appContext.setClassLoader((ClassLoader)PuiDynamicClassLoader.getInstance());
        this.appContext.getBeanFactory().setBeanClassLoader((ClassLoader)PuiDynamicClassLoader.getInstance());
        this.registerBeanDefinition(clazz);
        DtoRegistry.getDtoImplementation(null, (boolean)true);
        return this.factory.getBean(StringUtils.uncapitalize((String)clazz.getSimpleName()));
    }

    protected abstract boolean classPassFilter(Class<?> var1);

    protected abstract void registerBeanDefinition(Class<?> var1);
}

