/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.generator;

import es.prodevelop.codegen.pui9.db.CodegenModelsDatabaseUtils;
import es.prodevelop.codegen.pui9.model.ClientConfiguration;
import es.prodevelop.codegen.pui9.model.DatabaseConnection;
import es.prodevelop.codegen.pui9.model.PuiConfiguration;
import es.prodevelop.codegen.pui9.model.ServerConfiguration;
import es.prodevelop.codegen.pui9.model.Table;
import es.prodevelop.codegen.pui9.model.View;
import es.prodevelop.pui9.classpath.PuiClasspathFinderRegistry;
import es.prodevelop.pui9.classpath.PuiDynamicClassLoader;
import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.model.dao.registry.DaoRegistry;
import es.prodevelop.pui9.model.generator.TemplateFileInfo;
import es.prodevelop.pui9.model.generator.layers.AbstractControllerLayerGenerator;
import es.prodevelop.pui9.model.generator.layers.AbstractDaoLayerGenerator;
import es.prodevelop.pui9.model.generator.layers.AbstractServiceLayerGenerator;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.Reflections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class DynamicClassGenerator {
    public static final String GENERATED_FOLDER = "pui_generated";
    public static final String GENERATED_PACKAGE_NAME = "es.prodevelop.pui9.generated";
    public static final String FILENAME_WILDARD = "%filename%";
    public static final String READ_FUNCTIONALITY = "READ_PUI_GENERATED_ENTITY";
    public static final String WRITE_FUNCTIONALITY = "WRITE_PUI_GENERATED_ENTITY";
    public static final String GEN_FUNCTIONALITY = "GEN_PUI_GENERATED_ENTITY";
    public static final String PUI_VERSION_FOLDER = "1.x.y";
    private static final String TEMPLATE_FOLDER = "/versions/1.x.y/templates";
    private final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource datasource;
    @Autowired
    private AbstractDaoLayerGenerator daoLayerGenerator;
    @Autowired
    private DaoRegistry daoRegistry;
    @Autowired
    private IDatabaseHelper databaseHelper;
    @Autowired(required=false)
    private AbstractServiceLayerGenerator serviceLayerGenerator;
    @Autowired(required=false)
    private AbstractControllerLayerGenerator controllerLayerGenerator;
    private Configuration freemarkerConfig;
    private Set<String> generatedTablesCache = new HashSet<String>();
    private Set<String> generatedViewsCache = new HashSet<String>();
    private Reflections reflections;

    private DynamicClassGenerator() {
    }

    private void init() {
        if (this.freemarkerConfig == null && this.reflections == null) {
            this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_30);
            this.freemarkerConfig.setClassLoaderForTemplateLoading(Thread.currentThread().getContextClassLoader(), TEMPLATE_FOLDER);
            this.freemarkerConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_30));
            this.freemarkerConfig.setWhitespaceStripping(false);
            this.reflections = new Reflections(new Object[]{"es.prodevelop", PuiDynamicClassLoader.getInstance()});
        }
    }

    public synchronized void executeCodeGeneration(String tableName, String viewName) throws Exception {
        ArrayList<TemplateFileInfo> templateList;
        long start;
        block37: {
            ArrayList<TemplateFileInfo> controllerTemplateList;
            ArrayList<TemplateFileInfo> serviceTemplateList;
            ArrayList<TemplateFileInfo> daoTemplateList;
            ArrayList<TemplateFileInfo> javaTemplateList;
            PuiConfiguration model;
            boolean jarIncludedInClasspath;
            String view;
            String table;
            block35: {
                block36: {
                    this.init();
                    table = tableName;
                    view = viewName;
                    if (!ObjectUtils.isEmpty((Object)table)) {
                        if (this.daoRegistry.existsDaoForEntity(table)) {
                            this.logger.info((Object)("*** Table " + table + " already exists"));
                            table = null;
                        }
                        if (this.generatedTablesCache.contains(table)) {
                            this.logger.info((Object)("*** Table " + table + " was already generated"));
                            table = null;
                        }
                        if (table != null) {
                            this.generatedTablesCache.add(table);
                        }
                    }
                    if (!ObjectUtils.isEmpty((Object)view)) {
                        if (this.daoRegistry.existsDaoForEntity(view)) {
                            this.logger.info((Object)("*** View " + view + " already exists"));
                            view = null;
                        }
                        if (this.generatedViewsCache.contains(view)) {
                            this.logger.info((Object)("*** View " + view + " was already generated"));
                            view = null;
                        }
                        if (view != null) {
                            this.generatedViewsCache.add(view);
                        }
                    }
                    if (table == null && view == null) {
                        this.logger.info((Object)("*** Nothing to generate for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + ")"));
                        return;
                    }
                    start = System.currentTimeMillis();
                    jarIncludedInClasspath = false;
                    templateList = new ArrayList<TemplateFileInfo>();
                    this.logger.debug((Object)("*** Preparing models to generate code for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + ")"));
                    model = this.createGeneratorModel(table, view);
                    javaTemplateList = new ArrayList<TemplateFileInfo>();
                    daoTemplateList = new ArrayList<TemplateFileInfo>();
                    serviceTemplateList = new ArrayList<TemplateFileInfo>();
                    controllerTemplateList = new ArrayList<TemplateFileInfo>();
                    if (model.getServer().isGenerate()) {
                        if (model.getSelectedTable() != null) {
                            daoTemplateList.addAll(this.generateTableTemplates(model));
                        }
                        if (model.getSelectedView() != null) {
                            daoTemplateList.addAll(this.generateViewTemplates(model));
                        }
                        if (!daoTemplateList.isEmpty()) {
                            javaTemplateList.addAll(daoTemplateList);
                            if (model.getServer().isGenerateService()) {
                                serviceTemplateList.addAll(this.generateServiceTemplates(model));
                                javaTemplateList.addAll(serviceTemplateList);
                            }
                            if (model.getServer().isGenerateController()) {
                                controllerTemplateList.addAll(this.generateControllerTemplates(model));
                                javaTemplateList.addAll(controllerTemplateList);
                            }
                        }
                    }
                    templateList.addAll(javaTemplateList);
                    if (!CollectionUtils.isEmpty(templateList)) break block35;
                    this.logger.info((Object)("*** Nothing to generate for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + ")"));
                    if (jarIncludedInClasspath) break block36;
                    this.generatedTablesCache.remove(table);
                    this.generatedViewsCache.remove(view);
                }
                if (templateList != null) {
                    for (TemplateFileInfo tfi : templateList) {
                        if (tfi.getTempSrcFile() != null) {
                            Files.deleteIfExists(tfi.getTempSrcFile().toPath());
                        }
                        if (tfi.getTempBinFile() == null) continue;
                        Files.deleteIfExists(tfi.getTempBinFile().toPath());
                    }
                }
                long end = System.currentTimeMillis();
                long total = end - start;
                this.logger.debug((Object)("*** Finish generating code for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + "). Took " + total + "ms"));
                return;
            }
            try {
                File jarFile;
                this.logger.debug((Object)("*** Start generating code for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + ")"));
                String modelName = model.getSelectedTable() != null ? model.getSelectedTable().getJavaName() : model.getSelectedView().getJavaName();
                modelName = modelName.toLowerCase();
                this.createTempFiles(templateList);
                boolean serverCreated = false;
                if (model.getServer().isGenerate()) {
                    this.compileClasses(javaTemplateList);
                    serverCreated = true;
                }
                if ((jarFile = this.buildJar(((TemplateFileInfo)templateList.get(0)).getTempBinFolder(), modelName)) != null) {
                    this.loadJar(jarFile);
                }
                if (serverCreated) {
                    this.loadClasses(daoTemplateList, serviceTemplateList, controllerTemplateList);
                }
                if (jarIncludedInClasspath = true) break block37;
                this.generatedTablesCache.remove(table);
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)e.getMessage());
                    jarIncludedInClasspath = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!jarIncludedInClasspath) {
                        this.generatedTablesCache.remove(table);
                        this.generatedViewsCache.remove(view);
                    }
                    if (templateList != null) {
                        for (TemplateFileInfo tfi : templateList) {
                            if (tfi.getTempSrcFile() != null) {
                                Files.deleteIfExists(tfi.getTempSrcFile().toPath());
                            }
                            if (tfi.getTempBinFile() == null) continue;
                            Files.deleteIfExists(tfi.getTempBinFile().toPath());
                        }
                    }
                    long end = System.currentTimeMillis();
                    long total = end - start;
                    this.logger.debug((Object)("*** Finish generating code for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + "). Took " + total + "ms"));
                    throw throwable;
                }
            }
            this.generatedViewsCache.remove(view);
        }
        if (templateList != null) {
            for (TemplateFileInfo tfi : templateList) {
                if (tfi.getTempSrcFile() != null) {
                    Files.deleteIfExists(tfi.getTempSrcFile().toPath());
                }
                if (tfi.getTempBinFile() == null) continue;
                Files.deleteIfExists(tfi.getTempBinFile().toPath());
            }
        }
        long end = System.currentTimeMillis();
        long total = end - start;
        this.logger.debug((Object)("*** Finish generating code for: table (" + (!ObjectUtils.isEmpty((Object)tableName) ? tableName : "-") + ") / view (" + (!ObjectUtils.isEmpty((Object)viewName) ? viewName : "-") + "). Took " + total + "ms"));
    }

    private List<TemplateFileInfo> generateTableTemplates(PuiConfiguration model) throws Exception {
        List<TemplateFileInfo> tableTemplateList = Collections.emptyList();
        if (model.getSelectedTable() != null) {
            tableTemplateList = this.daoLayerGenerator.getTemplateList(false);
            this.generateTemplates(tableTemplateList, model, model.getSelectedTable().getJavaName());
        }
        return tableTemplateList;
    }

    private List<TemplateFileInfo> generateViewTemplates(PuiConfiguration model) throws Exception {
        List<TemplateFileInfo> viewTemplateList = Collections.emptyList();
        if (model.getSelectedView() != null) {
            viewTemplateList = this.daoLayerGenerator.getTemplateList(true);
            this.generateTemplates(viewTemplateList, model, model.getSelectedView().getJavaName());
        }
        return viewTemplateList;
    }

    private List<TemplateFileInfo> generateServiceTemplates(PuiConfiguration model) throws Exception {
        List<TemplateFileInfo> serviceTemplateList = Collections.emptyList();
        if (this.serviceLayerGenerator != null) {
            serviceTemplateList = this.serviceLayerGenerator.getTemplateList(false);
            this.generateTemplates(serviceTemplateList, model, model.getSelectedTable() != null ? model.getSelectedTable().getJavaName() : model.getSelectedView().getJavaName());
        }
        return serviceTemplateList;
    }

    private List<TemplateFileInfo> generateControllerTemplates(PuiConfiguration model) throws Exception {
        List<TemplateFileInfo> controllerTemplateList = Collections.emptyList();
        if (this.controllerLayerGenerator != null) {
            controllerTemplateList = this.controllerLayerGenerator.getTemplateList(false);
            this.generateTemplates(controllerTemplateList, model, model.getSelectedTable() != null ? model.getSelectedTable().getJavaName() : model.getSelectedView().getJavaName());
        }
        return controllerTemplateList;
    }

    private void generateTemplates(List<TemplateFileInfo> templateList, PuiConfiguration model, String modelName) throws Exception {
        for (TemplateFileInfo tfi : templateList) {
            StringWriter outputWriter = new StringWriter();
            this.freemarkerConfig.getTemplate(tfi.getTemplateName());
            this.freemarkerConfig.setSharedVariable("config", (Object)model);
            Template tpl = this.freemarkerConfig.getTemplate(tfi.getTemplateName());
            tpl.setOutputEncoding(StandardCharsets.UTF_8.name());
            tpl.process((Object)model, (Writer)outputWriter);
            outputWriter.flush();
            outputWriter.close();
            String contents = outputWriter.toString();
            if (tfi.getGeneratedFileName().contains(FILENAME_WILDARD)) {
                tfi.setFileName(tfi.getGeneratedFileName().replace(FILENAME_WILDARD, modelName));
            }
            tfi.setContents(contents);
        }
    }

    private PuiConfiguration createGeneratorModel(String tableName, String viewName) throws SQLException {
        PuiConfiguration model = new PuiConfiguration();
        CodegenModelsDatabaseUtils.singleton((Connection)this.datasource.getConnection());
        model.setDatabase(new DatabaseConnection());
        model.getDatabase().setConfiguration(model);
        model.getDatabase().setType(this.databaseHelper.getDatabaseType());
        model.setServer(new ServerConfiguration());
        model.getServer().setConfiguration(model);
        model.getServer().setDtoProject(GENERATED_PACKAGE_NAME);
        model.getServer().setDaoProject(GENERATED_PACKAGE_NAME);
        model.getServer().setBoProject(GENERATED_PACKAGE_NAME);
        model.getServer().setWebProject(GENERATED_PACKAGE_NAME);
        try {
            Class<?> abstractCommonControllerClass = Class.forName("es.prodevelop.pui9.controller.AbstractCommonController");
            Optional<Object> optAbstractControllerClass = this.reflections.getSubTypesOf(abstractCommonControllerClass).stream().filter(st -> ((Class)st).getSimpleName().equals("AbstractController")).findFirst();
            if (!optAbstractControllerClass.isPresent()) {
                throw new ClassNotFoundException();
            }
            model.getServer().setSuperController(((Class)optAbstractControllerClass.get()).getName());
        }
        catch (ClassNotFoundException e) {
            model.getServer().setSuperController("es.prodevelop.pui9.controller.AbstractCommonController");
        }
        model.getServer().setGenerate(true);
        model.getServer().setGenerateService(true);
        model.getServer().setGenerateController(true);
        try {
            Class.forName("es.prodevelop.pui9.geo.dto.interfaces.IGeoDto");
            model.getServer().setGeoProject(true);
        }
        catch (ClassNotFoundException e) {
            model.getServer().setGeoProject(false);
        }
        model.getServer().setUseAdvancedFunctionalities(false);
        model.setClient(new ClientConfiguration());
        model.getClient().setConfiguration(model);
        model.getClient().setGenerate(false);
        if (!ObjectUtils.isEmpty((Object)tableName)) {
            Table table = new Table();
            table.setConfiguration(model);
            table.setDbName(tableName);
            boolean exists = CodegenModelsDatabaseUtils.singleton().loadTable(table);
            if (exists) {
                model.setSelectedTable(table);
                model.getServer().setReadFunctionality(READ_FUNCTIONALITY);
                model.getServer().setWriteFunctionality(WRITE_FUNCTIONALITY);
            }
        }
        if (!ObjectUtils.isEmpty((Object)viewName)) {
            View view = new View();
            view.setConfiguration(model);
            view.setDbName(viewName);
            boolean exists = CodegenModelsDatabaseUtils.singleton().loadView(view);
            if (exists) {
                model.setSelectedView(view);
            }
        }
        if (model.getSelectedTable() != null) {
            model.setModelName(model.getSelectedTable().getLowercaseName());
        } else if (model.getSelectedView() != null) {
            model.setModelName(model.getSelectedView().getLowercaseName());
        }
        model.getServer().computeJavaAttributes();
        return model;
    }

    private void createTempFiles(List<TemplateFileInfo> templateList) throws Exception {
        File tempFolder = new File(FileUtils.getTempDirectory(), GENERATED_FOLDER + System.currentTimeMillis());
        File tempSrcFolder = new File(tempFolder, "src");
        tempSrcFolder.mkdirs();
        File tempBinFolder = new File(tempFolder, "bin");
        tempBinFolder.mkdirs();
        for (TemplateFileInfo tfi : templateList) {
            tfi.setTempBinFolder(tempBinFolder);
            tfi.setTempSrcFile(new File(tempSrcFolder, tfi.getFileName()));
            tfi.getTempSrcFile().createNewFile();
            FileWriter writer = new FileWriter(tfi.getTempSrcFile());
            writer.write(tfi.getContents());
            writer.close();
        }
    }

    private void compileClasses(List<TemplateFileInfo> templateList) throws Exception {
        File binFolder = templateList.get(0).getTempBinFolder();
        ArrayList<File> files = new ArrayList<File>();
        for (TemplateFileInfo tfi : templateList) {
            files.add(tfi.getTempSrcFile());
            String subfolders = tfi.getPackageName().replace(".", "/");
            String name = subfolders + File.separator + tfi.getFileName().replace(JavaFileObject.Kind.SOURCE.extension, JavaFileObject.Kind.CLASS.extension);
            tfi.setTempBinFile(new File(binFolder, name));
        }
        List classpath = PuiClasspathFinderRegistry.getInstance().getClasspath();
        if (classpath.isEmpty()) {
            throw new Exception("No classpath available");
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(binFolder));
        fileManager.setLocation(StandardLocation.CLASS_PATH, classpath);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        boolean result = compiler.getTask(null, fileManager, null, null, null, compilationUnits).call();
        fileManager.close();
        if (!result) {
            throw new Exception("Generated code do not compile");
        }
    }

    private File buildJar(File tempBinFolder, String entityName) throws Exception {
        File jarFile = new File(tempBinFolder, "es.prodevelop.pui9.generated." + entityName + ".jar");
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(jarFile);
        File jarFolder = new File(tempBinFolder, GENERATED_PACKAGE_NAME.split("\\.")[0]);
        this.addFileToZip(zaos, jarFolder.getPath(), "");
        FileUtils.deleteDirectory((File)jarFolder);
        zaos.close();
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToZip(ZipArchiveOutputStream zipOutputStream, String path, String base) throws Exception {
        block5: {
            String entryName;
            File f;
            block4: {
                f = new File(path);
                entryName = base + f.getName();
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(f, entryName);
                zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                if (!f.isFile()) break block4;
                FileInputStream fInputStream = null;
                try {
                    fInputStream = new FileInputStream(f);
                    IOUtils.copy((InputStream)fInputStream, (OutputStream)zipOutputStream);
                    zipOutputStream.closeArchiveEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)fInputStream);
                break block5;
            }
            zipOutputStream.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.addFileToZip(zipOutputStream, child.getAbsolutePath(), entryName + "/");
                }
            }
        }
    }

    private void loadJar(File jarFile) throws Exception {
        PuiDynamicClassLoader classLoader = PuiDynamicClassLoader.getInstance();
        URL jarUrl = jarFile.toURI().toURL();
        classLoader.addURL(jarUrl);
    }

    private void loadClasses(List<TemplateFileInfo> daoTemplateList, List<TemplateFileInfo> serviceTemplateList, List<TemplateFileInfo> controllerTemplateList) throws Exception {
        this.daoLayerGenerator.registerClasses(daoTemplateList);
        if (this.serviceLayerGenerator != null) {
            this.serviceLayerGenerator.registerClasses(serviceTemplateList);
        }
        if (this.controllerLayerGenerator != null) {
            this.controllerLayerGenerator.registerClasses(controllerTemplateList);
        }
    }
}

