/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao.registry;

import es.prodevelop.pui9.annotations.PuiEntity;
import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.model.dao.interfaces.IDao;
import es.prodevelop.pui9.model.dao.interfaces.ITableDao;
import es.prodevelop.pui9.model.dao.interfaces.IViewDao;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.INullTable;
import es.prodevelop.pui9.model.dto.interfaces.INullView;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.model.dto.interfaces.IViewDto;
import es.prodevelop.pui9.model.generator.DynamicClassGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class DaoRegistry {
    private List<Class<? extends IDao>> registeredDaos;
    private Map<Class<? extends IDao>, String> mapEntityNameFromDao;
    private Map<String, Class<? extends IDao>> mapDaoFromEntityName;
    private Map<Class<? extends IDao>, String> mapEntityLangNameFromDao;
    private Map<String, List<Class<? extends IDto>>> mapDtoListFromEntityName;
    private Map<String, Class<? extends ITableDao>> mapTableDaoFromModelId;
    private Map<String, Class<? extends IViewDao>> mapViewDaoFromModelId;
    private Map<String, List<Class<? extends ITableDto>>> mapTableDtoListFromModelId;
    private Map<String, Class<? extends IViewDto>> mapViewDtoFromModelId;
    private Map<Class<? extends IDto>, String> mapModelIdFromDto;
    private Map<Class<? extends IDao>, String> mapModelIdFromDao;
    private Map<Class<? extends IDao>, List<Class<? extends IDto>>> mapDtosFromDao;
    private Map<Class<? extends IDto>, Class<? extends IDao>> mapDaoFromDto;
    private Map<Class<? extends ITableDao>, List<Class<? extends IViewDao>>> mapViewDaoListFromTableDao;
    private Map<Class<? extends IViewDao>, Class<? extends ITableDao>> mapTableDaoFromViewDao;
    private Map<Class<? extends ITableDto>, List<Class<? extends IViewDto>>> mapViewDtoListFromTableDto;
    private Map<Class<? extends IViewDto>, Class<? extends ITableDto>> mapTableDtoFromViewDto;
    private Map<Class<? extends IDao>, Class<? extends IDao>> daoCache = new LinkedHashMap<Class<? extends IDao>, Class<? extends IDao>>();

    private DaoRegistry() {
        this.registeredDaos = new ArrayList<Class<? extends IDao>>();
        this.mapEntityNameFromDao = new LinkedHashMap<Class<? extends IDao>, String>();
        this.mapDaoFromEntityName = new LinkedHashMap<String, Class<? extends IDao>>();
        this.mapEntityLangNameFromDao = new LinkedHashMap<Class<? extends IDao>, String>();
        this.mapDtoListFromEntityName = new LinkedHashMap<String, List<Class<? extends IDto>>>();
        this.mapTableDtoListFromModelId = new LinkedHashMap<String, List<Class<? extends ITableDto>>>();
        this.mapViewDtoFromModelId = new LinkedHashMap<String, Class<? extends IViewDto>>();
        this.mapTableDaoFromModelId = new LinkedHashMap<String, Class<? extends ITableDao>>();
        this.mapViewDaoFromModelId = new LinkedHashMap<String, Class<? extends IViewDao>>();
        this.mapModelIdFromDto = new LinkedHashMap<Class<? extends IDto>, String>();
        this.mapModelIdFromDao = new LinkedHashMap<Class<? extends IDao>, String>();
        this.mapDtosFromDao = new LinkedHashMap<Class<? extends IDao>, List<Class<? extends IDto>>>();
        this.mapDaoFromDto = new LinkedHashMap<Class<? extends IDto>, Class<? extends IDao>>();
        this.mapViewDaoListFromTableDao = new LinkedHashMap<Class<? extends ITableDao>, List<Class<? extends IViewDao>>>();
        this.mapTableDaoFromViewDao = new LinkedHashMap<Class<? extends IViewDao>, Class<? extends ITableDao>>();
        this.mapViewDtoListFromTableDto = new LinkedHashMap<Class<? extends ITableDto>, List<Class<? extends IViewDto>>>();
        this.mapTableDtoFromViewDto = new LinkedHashMap<Class<? extends IViewDto>, Class<? extends ITableDto>>();
    }

    public void relatedDaos(Class<? extends ITableDao> tableDaoClass, Class<? extends IViewDao> viewDaoClass) {
        if (!this.mapViewDaoListFromTableDao.containsKey(tableDaoClass)) {
            this.mapViewDaoListFromTableDao.put(tableDaoClass, new ArrayList());
        }
        this.mapViewDaoListFromTableDao.get(tableDaoClass).add(viewDaoClass);
        this.mapTableDaoFromViewDao.put(viewDaoClass, tableDaoClass);
    }

    public void relatedDtos(Class<? extends ITableDto> tableDtoPkClass, Class<? extends ITableDto> tableDtoClass, Class<? extends IViewDto> viewDtoClass) {
        if (!this.mapViewDtoListFromTableDto.containsKey(tableDtoPkClass)) {
            this.mapViewDtoListFromTableDto.put(tableDtoPkClass, new ArrayList());
        }
        if (!this.mapViewDtoListFromTableDto.containsKey(tableDtoClass)) {
            this.mapViewDtoListFromTableDto.put(tableDtoClass, new ArrayList());
        }
        this.mapViewDtoListFromTableDto.get(tableDtoPkClass).add(viewDtoClass);
        this.mapViewDtoListFromTableDto.get(tableDtoClass).add(viewDtoClass);
        this.mapTableDtoFromViewDto.put(viewDtoClass, tableDtoClass);
    }

    public void registerModelDaos(String modelId, Class<? extends ITableDto> tableDtoPkClass, Class<? extends ITableDto> tableDtoClass, Class<? extends IViewDto> viewDtoClass, Class<? extends ITableDao> tableDaoClass, Class<? extends IViewDao> viewDaoClass) {
        Class<?> tableDtoPkIface = tableDtoPkClass.getInterfaces()[0];
        Class<?> tableDtoIface = tableDtoClass.getInterfaces()[0];
        Class<?> viewDtoIface = viewDtoClass.getInterfaces()[0];
        Class<?> tableDaoIface = tableDaoClass.getInterfaces()[0];
        Class<?> viewDaoIface = viewDaoClass.getInterfaces()[0];
        this.mapTableDaoFromModelId.put(modelId, tableDaoIface);
        this.mapViewDaoFromModelId.put(modelId, viewDaoIface);
        this.mapModelIdFromDao.put(tableDaoIface, modelId);
        this.mapModelIdFromDao.put(viewDaoIface, modelId);
        if (!tableDtoIface.equals(INullTable.class)) {
            this.mapModelIdFromDto.put(tableDtoPkIface, modelId);
            this.mapModelIdFromDto.put(tableDtoPkClass, modelId);
            this.mapModelIdFromDto.put(tableDtoIface, modelId);
            this.mapModelIdFromDto.put(tableDtoClass, modelId);
        }
        if (!viewDtoIface.equals(INullView.class)) {
            this.mapModelIdFromDto.put(viewDtoIface, modelId);
            this.mapModelIdFromDto.put(viewDtoClass, modelId);
        }
        this.mapTableDtoListFromModelId.put(modelId, new ArrayList());
        this.mapTableDtoListFromModelId.get(modelId).add(tableDtoPkClass);
        this.mapTableDtoListFromModelId.get(modelId).add(tableDtoClass);
        this.mapViewDtoFromModelId.put(modelId, viewDtoClass);
    }

    public void registerDao(Class<? extends IDao> daoClass) {
        if (this.registeredDaos.contains(daoClass)) {
            return;
        }
        Class<?> iface = daoClass.getInterfaces()[0];
        ParameterizedType superType = (ParameterizedType)daoClass.getGenericSuperclass();
        this.registeredDaos.add(iface);
        this.mapDtosFromDao.put(iface, new ArrayList());
        this.mapDtosFromDao.put(daoClass, new ArrayList());
        ArrayList<Class> typeParameters = new ArrayList<Class>();
        for (Type type : superType.getActualTypeArguments()) {
            typeParameters.add(0, (Class)type);
        }
        String tablename = "";
        for (Class type : typeParameters) {
            Class dtoIface = type;
            Class dtoClass = DtoRegistry.getDtoImplementation((Class)dtoIface);
            PuiEntity puiTable = dtoClass.getAnnotation(PuiEntity.class);
            if (puiTable != null) {
                tablename = puiTable.tablename().toLowerCase();
                String tabletranslationname = puiTable.tabletranslationname();
                this.mapEntityNameFromDao.put(iface, tablename);
                this.mapDaoFromEntityName.put(tablename, iface);
                if (tabletranslationname.isEmpty()) {
                    this.mapEntityLangNameFromDao.put(iface, null);
                } else {
                    this.mapEntityLangNameFromDao.put(iface, tabletranslationname);
                }
                this.mapDtoListFromEntityName.put(tablename, new ArrayList());
            }
            DtoRegistry.registerDto((Class)dtoClass);
            this.mapDtosFromDao.get(iface).add(dtoClass);
            this.mapDtosFromDao.get(daoClass).add(dtoClass);
            this.mapDaoFromDto.put(dtoIface, iface);
            this.mapDaoFromDto.put(dtoClass, iface);
            this.mapDtoListFromEntityName.get(tablename).add(dtoClass);
        }
    }

    private void checkDaoExistsAndGenerate(String entityName) {
        if (ObjectUtils.isEmpty((Object)entityName)) {
            return;
        }
        if (!this.mapDaoFromEntityName.containsKey(entityName.toLowerCase())) {
            try {
                DtoRegistry.getDtoImplementation(null, (boolean)true);
                PuiApplicationContext.getInstance().getBean(DynamicClassGenerator.class).executeCodeGeneration(entityName, entityName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean existsDaoForEntity(String entityName) {
        if (ObjectUtils.isEmpty((Object)entityName)) {
            return false;
        }
        return this.mapDaoFromEntityName.containsKey(entityName.toLowerCase());
    }

    public boolean hasLanguageSupport(IDao dao) {
        return this.hasLanguageSupport(this.unwrapDaoClass(dao));
    }

    public boolean hasLanguageSupport(Class<? extends IDao> daoClass) {
        return this.getTableLangName(daoClass) != null;
    }

    public String getEntityName(IDao dao) {
        return this.getEntityName(this.unwrapDaoClass(dao));
    }

    public String getEntityName(Class<? extends IDao> daoClass) {
        daoClass = this.getDaoInterface(daoClass);
        return this.mapEntityNameFromDao.get(daoClass);
    }

    public List<String> getAllEntityNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.mapEntityNameFromDao.values());
        return list;
    }

    public <T extends IDao> Class<T> getDaoFromEntityName(String entityName, boolean generateIfNotExists) {
        if (ObjectUtils.isEmpty((Object)entityName)) {
            return null;
        }
        if (generateIfNotExists) {
            this.checkDaoExistsAndGenerate(entityName);
        }
        return this.mapDaoFromEntityName.get(entityName.toLowerCase());
    }

    public <T extends IDto> Class<T> getDtoFromEntityName(String entityName, boolean wantPkDto, boolean generateIfNotExists) {
        List<Class<? extends IDto>> classes;
        Class<T> dtoClass;
        if (ObjectUtils.isEmpty((Object)entityName)) {
            return null;
        }
        if (generateIfNotExists) {
            this.checkDaoExistsAndGenerate(entityName);
        }
        if ((dtoClass = this.getDto(classes = this.mapDtoListFromEntityName.get(entityName.toLowerCase()), wantPkDto)) == null && !generateIfNotExists) {
            throw new IllegalArgumentException("Error getting the DTO of the table '" + entityName + "'");
        }
        return dtoClass;
    }

    public <T extends ITableDto> Class<T> getTableDtoFromModelId(String modelId, boolean wantPkDto, boolean generateIfNotExists) {
        if (ObjectUtils.isEmpty((Object)modelId)) {
            return null;
        }
        Class<? extends ITableDao> daoClass = this.getTableDaoFromModelId(modelId);
        String entityName = this.getEntityName(daoClass);
        if (daoClass == null && generateIfNotExists) {
            this.checkDaoExistsAndGenerate(entityName);
        } else if (daoClass == null) {
            return null;
        }
        List<Class<? extends IDto>> classes = this.mapDtoListFromEntityName.get(entityName.toLowerCase());
        Class<T> dtoClass = this.getDto(classes, wantPkDto);
        if (dtoClass == null && !generateIfNotExists) {
            throw new IllegalArgumentException("Error getting the DTO of the table '" + entityName + "'");
        }
        return dtoClass;
    }

    public Class<? extends ITableDto> getTableDtoFromModelId(String modelId, boolean wantPkDto) {
        List<Class<? extends ITableDto>> classes = this.mapTableDtoListFromModelId.get(modelId.toLowerCase());
        if (CollectionUtils.isEmpty(classes)) {
            return null;
        }
        Class<? extends ITableDto> tableDtoClass = null;
        for (Class<? extends ITableDto> clazz : classes) {
            if (tableDtoClass == null) {
                tableDtoClass = clazz;
                continue;
            }
            if (tableDtoClass.isAssignableFrom(clazz) && wantPkDto) continue;
            tableDtoClass = clazz;
        }
        return tableDtoClass;
    }

    public Class<? extends IViewDto> getViewDtoFromModelId(String modelId) {
        return this.mapViewDtoFromModelId.get(modelId.toLowerCase());
    }

    public <T extends IViewDto> Class<T> getViewDtoFromModelId(String modelId, boolean generateIfNotExists) {
        if (ObjectUtils.isEmpty((Object)modelId)) {
            return null;
        }
        Class<? extends IViewDao> daoClass = this.getViewDaoFromModelId(modelId);
        String entityName = this.getEntityName(daoClass);
        if (daoClass == null && generateIfNotExists) {
            this.checkDaoExistsAndGenerate(entityName);
        } else if (daoClass == null) {
            return null;
        }
        List<Class<? extends IDto>> classes = this.mapDtoListFromEntityName.get(entityName.toLowerCase());
        Class<T> dtoClass = this.getDto(classes, false);
        if (dtoClass == null && !generateIfNotExists) {
            throw new IllegalArgumentException("Error getting the DTO of the table '" + entityName + "'");
        }
        return dtoClass;
    }

    public String getTableLangName(IDao dao) {
        return this.getTableLangName(this.unwrapDaoClass(dao));
    }

    public String getTableLangName(Class<? extends IDao> daoClass) {
        daoClass = this.getDaoInterface(daoClass);
        return this.mapEntityLangNameFromDao.get(daoClass);
    }

    public List<Class<? extends IDao>> getAllTableDaoLang() {
        ArrayList<Class<? extends IDao>> list = new ArrayList<Class<? extends IDao>>();
        for (Map.Entry<Class<? extends IDao>, String> entry : this.mapEntityLangNameFromDao.entrySet()) {
            if (entry.getValue() == null) continue;
            list.add(this.getDaoFromEntityName(entry.getValue(), false));
        }
        return list;
    }

    public List<Class<? extends IDao>> getAllDaos() {
        ArrayList<Class<? extends IDao>> allDaos = new ArrayList<Class<? extends IDao>>();
        allDaos.addAll(this.mapTableDaoFromModelId.values());
        allDaos.addAll(this.mapViewDaoFromModelId.values());
        return allDaos;
    }

    public Class<? extends ITableDao> getTableDaoFromModelId(String modelId) {
        return this.mapTableDaoFromModelId.get(modelId);
    }

    public Class<? extends IViewDao> getViewDaoFromModelId(String modelId) {
        return this.mapViewDaoFromModelId.get(modelId);
    }

    public List<String> getAllModelId() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.mapTableDaoFromModelId.keySet());
        set.addAll(this.mapViewDaoFromModelId.keySet());
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    public String getModelIdFromDto(Class<? extends IDto> dtoClass) {
        return this.mapModelIdFromDto.get(dtoClass);
    }

    public String getModelIdFromDao(Class<? extends IDao> daoClass) {
        daoClass = this.getDaoInterface(daoClass);
        return this.mapModelIdFromDao.get(daoClass);
    }

    public <T extends IDto> Class<T> getDtoFromDao(Class<? extends IDao> daoClass, boolean wantPkDto) {
        List<Class<? extends IDto>> classes = this.mapDtosFromDao.get(daoClass);
        Class<T> dtoClass = this.getDto(classes, wantPkDto);
        if (dtoClass == null) {
            throw new IllegalArgumentException("Error getting the DTO of the table '" + daoClass.getSimpleName() + "'");
        }
        return dtoClass;
    }

    public <T extends IDao> Class<T> getDaoFromDto(Class<? extends IDto> dtoClass) {
        Class<? extends IDao> daoClass = this.mapDaoFromDto.get(dtoClass);
        return daoClass;
    }

    public List<Class<? extends IViewDao>> getViewDaoFromTableDao(Class<? extends ITableDao> tableDaoClass) {
        return this.mapViewDaoListFromTableDao.get(tableDaoClass);
    }

    public Class<? extends ITableDao> getTableDaoFromViewDao(Class<? extends IViewDao> viewDaoClass) {
        return this.mapTableDaoFromViewDao.get(viewDaoClass);
    }

    public List<Class<? extends IViewDto>> getViewDtoFromTableDto(Class<? extends ITableDto> tableDtoClass) {
        return this.mapViewDtoListFromTableDto.get(tableDtoClass);
    }

    public Class<? extends ITableDto> getTableDtoFromViewDto(Class<? extends IViewDto> viewDtoClass) {
        return this.mapTableDtoFromViewDto.get(viewDtoClass);
    }

    private Class<? extends IDao> unwrapDaoClass(IDao dao) {
        if (dao == null) {
            return null;
        }
        Class clazz = dao.getDaoClass();
        clazz = this.getDaoInterface(clazz);
        return clazz;
    }

    private <T extends IDao> Class<? extends T> getDaoInterface(Class<? extends T> daoClass) {
        if (daoClass == null) {
            return null;
        }
        if (daoClass.isInterface()) {
            return daoClass;
        }
        Class<IDao<Object>> cacheDaoClass = this.daoCache.get(daoClass);
        if (cacheDaoClass == null) {
            for (Class<?> iface : daoClass.getInterfaces()) {
                if (!iface.getSimpleName().contains(daoClass.getSimpleName())) continue;
                cacheDaoClass = iface;
                this.daoCache.put(daoClass, cacheDaoClass);
                break;
            }
        }
        return cacheDaoClass;
    }

    private <T extends IDto> Class<T> getDto(List<Class<? extends IDto>> classes, boolean wantPkDto) {
        if (CollectionUtils.isEmpty(classes) || classes.size() > 2) {
            return null;
        }
        if (classes.size() == 1) {
            return classes.get(0);
        }
        Class<? extends IDto> class1 = classes.get(0);
        Class<? extends IDto> class2 = classes.get(1);
        if (wantPkDto) {
            if (class1.isAssignableFrom(class2)) {
                return class1;
            }
            if (class2.isAssignableFrom(class1)) {
                return class2;
            }
            throw new IllegalArgumentException("Bad DTO detected");
        }
        if (class1.isAssignableFrom(class2)) {
            return class2;
        }
        if (class2.isAssignableFrom(class1)) {
            return class1;
        }
        throw new IllegalArgumentException("Bad DTO detected");
    }
}

