/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao.interfaces;

import es.prodevelop.pui9.exceptions.PuiDaoDeleteException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoInsertException;
import es.prodevelop.pui9.exceptions.PuiDaoSaveException;
import es.prodevelop.pui9.exceptions.PuiDaoUpdateException;
import es.prodevelop.pui9.exceptions.PuiException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.model.dao.interfaces.IDao;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.utils.PuiLanguage;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public interface ITableDao<TPK extends ITableDto, T extends TPK>
extends IDao<T> {
    public boolean exists(TPK var1) throws PuiDaoFindException;

    @Transactional(rollbackFor={PuiException.class})
    public T insert(T var1) throws PuiDaoInsertException;

    @Transactional(rollbackFor={PuiException.class})
    public T update(T var1) throws PuiDaoUpdateException;

    @Transactional(rollbackFor={PuiException.class})
    public List<T> bulkInsert(List<T> var1) throws PuiDaoInsertException;

    @Transactional(rollbackFor={PuiException.class})
    public List<T> bulkUpdate(List<T> var1) throws PuiDaoUpdateException;

    @Transactional(rollbackFor={PuiException.class})
    public void bulkPatch(List<TPK> var1, Map<String, Object> var2) throws PuiDaoUpdateException;

    @Transactional(rollbackFor={PuiException.class})
    public TPK patch(TPK var1, Map<String, Object> var2) throws PuiDaoSaveException;

    @Transactional(rollbackFor={PuiException.class})
    public TPK delete(TPK var1) throws PuiDaoDeleteException;

    @Transactional(rollbackFor={PuiException.class})
    public List<TPK> bulkDelete(List<TPK> var1) throws PuiDaoDeleteException;

    @Transactional(rollbackFor={PuiException.class})
    public void deleteAll() throws PuiDaoDeleteException;

    @Transactional(rollbackFor={PuiException.class})
    public void deleteAll(PuiLanguage var1) throws PuiDaoDeleteException;

    @Transactional(rollbackFor={PuiException.class})
    public void deleteWhere(FilterBuilder var1) throws PuiDaoDeleteException;

    public T findOne(TPK var1) throws PuiDaoFindException;

    public T findOne(TPK var1, PuiLanguage var2) throws PuiDaoFindException;

    public Class<TPK> getDtoPkClass();

    public ITableDao<ITableDto, ITableDto> getTableTranslationDao();

    @Override
    public Class<? extends ITableDao<TPK, T>> getDaoClass();
}

