/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.model.dao.AbstractDao;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.jdbc.core.RowMapper;

public class DaoRowMapper<T extends IDto>
implements RowMapper<T> {
    private AbstractDao<T> dao;
    private Class<T> dtoClass;

    public DaoRowMapper(AbstractDao<T> dao, Class<T> dtoClass) {
        this.dao = dao;
        this.dtoClass = dtoClass;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        IDto dto;
        try {
            dto = (IDto)this.dtoClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        DtoRegistry.getAllColumnNames(this.dtoClass).forEach(columnName -> {
            try {
                String fieldName = DtoRegistry.getFieldNameFromColumnName(this.dtoClass, (String)columnName);
                Field field = DtoRegistry.getJavaFieldFromColumnName(this.dtoClass, (String)columnName);
                if (field == null) {
                    field = DtoRegistry.getJavaFieldFromLangFieldName(this.dtoClass, (String)fieldName);
                }
                Object value = null;
                value = DtoRegistry.getDateTimeFields(this.dtoClass).contains(fieldName) ? rs.getTimestamp((String)columnName) : rs.getObject((String)columnName);
                value = this.extractRealValue(field, value);
                FieldUtils.writeField((Field)field, (Object)dto, (Object)value, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (this.dao != null) {
            this.dao.customizeDto(dto);
        }
        return (T)dto;
    }

    private Object extractRealValue(Field field, Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Array) {
                ArrayList<Object> list = new ArrayList<Object>();
                Object[] array = (Object[])((Array)value).getArray();
                list.addAll(Arrays.asList(array));
                value = list;
            } else if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                Instant instant = timestamp.toInstant();
                value = instant;
            } else if (value instanceof Double) {
                if (field.getType().equals(BigDecimal.class)) {
                    value = new BigDecimal(((Double)value).toString());
                }
            } else if (value instanceof Float) {
                if (field.getType().equals(BigDecimal.class)) {
                    value = new BigDecimal(((Float)value).toString());
                }
            } else if (value instanceof BigDecimal) {
                value = field.getType().equals(Long.class) ? (Number)((BigDecimal)value).longValue() : (Number)(field.getType().equals(Integer.class) ? Integer.valueOf(((BigDecimal)value).intValue()) : new BigDecimal(((BigDecimal)value).stripTrailingZeros().toPlainString()));
            } else if (value instanceof Integer) {
                if (field.getType().equals(Short.class)) {
                    value = Short.valueOf(value.toString());
                }
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                StringWriter stringWriter = new StringWriter();
                IOUtils.copy((Reader)clob.getCharacterStream(), (Writer)stringWriter);
                value = stringWriter.toString();
            } else if (!(value instanceof String) && !(value instanceof Boolean) && field.getType().equals(String.class)) {
                value = value.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

