/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.eventlistener.ThreadDaoEvents;
import es.prodevelop.pui9.eventlistener.event.DeleteDaoEvent;
import es.prodevelop.pui9.eventlistener.event.InsertDaoEvent;
import es.prodevelop.pui9.eventlistener.event.UpdateDaoEvent;
import es.prodevelop.pui9.exceptions.PuiDaoAttributeLengthException;
import es.prodevelop.pui9.exceptions.PuiDaoDataAccessException;
import es.prodevelop.pui9.exceptions.PuiDaoDeleteException;
import es.prodevelop.pui9.exceptions.PuiDaoDuplicatedException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoInsertException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnDeleteException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnInsertException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnUpdateException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.exceptions.PuiDaoNullParametersException;
import es.prodevelop.pui9.exceptions.PuiDaoSaveException;
import es.prodevelop.pui9.exceptions.PuiDaoUpdateException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.AbstractDao;
import es.prodevelop.pui9.model.dao.interfaces.ITableDao;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.utils.PuiConstants;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import es.prodevelop.pui9.utils.PuiObjectUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jooq.DeleteConditionStep;
import org.jooq.DeleteUsingStep;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractTableDao<TPK extends ITableDto, T extends TPK>
extends AbstractDao<T>
implements ITableDao<TPK, T> {
    @Autowired
    private ThreadDaoEvents threadDaoEvents;
    private ITableDao<ITableDto, ITableDto> tableTranslationDao = null;

    @Override
    public boolean exists(TPK dtoPk) throws PuiDaoFindException {
        return this.findOne(dtoPk) != null;
    }

    @Override
    public T findOne(TPK dtoPk) throws PuiDaoFindException {
        return this.findOne(dtoPk, PuiUserSession.getSessionLanguage());
    }

    @Override
    public T findOne(TPK dtoPk, PuiLanguage language) throws PuiDaoFindException {
        if (dtoPk == null) {
            return null;
        }
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        FilterBuilder filterBuilder = FilterBuilder.newAndFilter();
        for (String next : pkColumnNames) {
            try {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(next);
                if (field == null) continue;
                Object val = FieldUtils.readField((java.lang.reflect.Field)field, dtoPk, (boolean)true);
                filterBuilder.addEquals(next, val);
            }
            catch (Exception exception) {}
        }
        List list = this.findWhere(filterBuilder, language);
        if (!list.isEmpty()) {
            return (T)((ITableDto)list.get(0));
        }
        return null;
    }

    @Override
    public T insert(T dto) throws PuiDaoInsertException {
        if (dto == null) {
            return null;
        }
        try {
            this.checkValues((ITableDto)dto);
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoInsertException(e);
        }
        try {
            this.prepareInsert(Collections.singletonList(dto));
            this.insertTranslations(Collections.singletonList(dto));
            this.afterInsert(Collections.singletonList(dto));
            return dto;
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoInsertException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnInsertException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoInsertException(new PuiDaoDataAccessException(e));
        }
    }

    @Override
    public List<T> bulkInsert(List<T> dtoList) throws PuiDaoInsertException {
        if (dtoList == null) {
            return Collections.emptyList();
        }
        try {
            for (ITableDto dto : dtoList) {
                this.checkValues(dto);
            }
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoInsertException(e);
        }
        try {
            this.prepareInsert(dtoList);
            this.insertTranslations(dtoList);
            this.afterInsert(dtoList);
            return dtoList;
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoInsertException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnInsertException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoInsertException(new PuiDaoDataAccessException(e));
        }
    }

    protected void prepareInsert(List<T> dtoList) throws DataAccessException {
        try {
            this.setAutoincrementableValues(dtoList);
        }
        catch (PuiDaoNoNumericColumnException e) {
            return;
        }
        Table table = DSL.table((String)this.getEntityName());
        ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames(this.getDtoClass()));
        columnNames.removeAll(DtoRegistry.getSequenceColumns(this.getDtoClass()));
        List columns = columnNames.stream().map(DSL::field).collect(Collectors.toList());
        List values = columnNames.stream().map(colName -> DSL.field((String)this.getParameterTextForColumnInsert((String)colName))).collect(Collectors.toList());
        InsertValuesStepN insert = this.dbHelper.getDSLContext().insertInto(table).columns(columns).values(values);
        if (this.onInsertConflictDoNothing()) {
            insert.onConflictDoNothing();
        }
        this.executeInsert(dtoList, insert.getSQL());
    }

    protected String getParameterTextForColumnInsert(String columnName) {
        return "?";
    }

    protected boolean onInsertConflictDoNothing() {
        return false;
    }

    protected void setAutoincrementableValues(List<T> dtoList) throws PuiDaoNoNumericColumnException {
        List fieldNames = DtoRegistry.getAutoincrementableFieldNames(this.getDtoClass());
        for (String fieldName : fieldNames) {
            try {
                java.lang.reflect.Field field = DtoRegistry.getJavaFieldFromFieldName(this.getDtoClass(), (String)fieldName);
                if (field.get(dtoList.get(0)) != null) continue;
                String columnName = DtoRegistry.getColumnNameFromFieldName(this.getDtoClass(), (String)fieldName);
                FilterBuilder filterBuilder = this.getAutoincrementableColumnFilter((ITableDto)dtoList.get(0), columnName);
                Object nextId = this.getNextValue(columnName, filterBuilder);
                for (ITableDto dto : dtoList) {
                    FieldUtils.writeField((java.lang.reflect.Field)field, (Object)dto, nextId, (boolean)true);
                    if (nextId instanceof Long) {
                        nextId = ((Number)nextId).longValue() + 1L;
                        continue;
                    }
                    if (!(nextId instanceof Integer)) continue;
                    nextId = ((Number)nextId).intValue() + 1;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
        }
    }

    protected FilterBuilder getAutoincrementableColumnFilter(T dto, String columnName) {
        return null;
    }

    protected void executeInsert(final List<T> dtoList, final String sql) throws DataAccessException {
        final ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames(this.getDtoClass()));
        final List sequenceColumns = DtoRegistry.getSequenceColumns(this.getDtoClass());
        columnNames.removeAll(sequenceColumns);
        final Map map = DtoRegistry.getMapFieldsFromColumnName(this.getDtoClass());
        if (dtoList.size() == 1) {
            GeneratedKeyHolder holder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement statement = sequenceColumns.isEmpty() ? con.prepareStatement(sql, 1) : con.prepareStatement(sql, sequenceColumns.toArray(new String[0]));
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object objValue;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            objValue = FieldUtils.readField((java.lang.reflect.Field)field, dtoList.get(0), (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (objValue instanceof Instant) {
                            objValue = Timestamp.from((Instant)objValue);
                        }
                        objValue = AbstractTableDao.this.modifyInsertColumnValue((ITableDto)dtoList.get(0), columnName, objValue);
                        statement.setObject(nextParameter++, objValue);
                    }
                    return statement;
                }
            }, (KeyHolder)holder);
            for (String seqCol : sequenceColumns) {
                Number val;
                block14: {
                    val = null;
                    try {
                        if (holder.getKeys() != null && holder.getKeys().containsKey(seqCol)) {
                            val = holder.getKeys().get(seqCol);
                        }
                        if (val != null) break block14;
                        val = holder.getKey();
                    }
                    catch (InvalidDataAccessApiUsageException e) {
                        break;
                    }
                }
                if (val == null) continue;
                java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(seqCol);
                if (!field.getType().equals(val.getClass())) {
                    if (Long.class.equals(field.getType())) {
                        val = new Long(val.toString());
                    } else if (Integer.class.equals(field.getType())) {
                        val = new Integer(val.toString());
                    } else if (BigDecimal.class.equals(field.getType())) {
                        val = new BigDecimal(val.toString());
                    }
                }
                try {
                    FieldUtils.writeField((java.lang.reflect.Field)field, dtoList.get(0), (Object)val, (boolean)true);
                }
                catch (Exception exception) {}
            }
        } else {
            this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dto = (ITableDto)dtoList.get(i);
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object objValue;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            objValue = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (objValue instanceof Instant) {
                            objValue = Timestamp.from((Instant)objValue);
                        }
                        objValue = AbstractTableDao.this.modifyInsertColumnValue((ITableDto)dtoList.get(0), columnName, objValue);
                        ps.setObject(nextParameter++, objValue);
                    }
                }

                public int getBatchSize() {
                    return dtoList.size();
                }
            });
        }
    }

    protected Object modifyInsertColumnValue(T dto, String columnName, Object value) {
        return value;
    }

    private void insertTranslations(List<T> dtoList) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        java.lang.reflect.Field langField = DtoRegistry.getJavaFieldFromColumnName(translationClass, (String)"lang");
        java.lang.reflect.Field langStatusField = DtoRegistry.getJavaFieldFromColumnName(translationClass, (String)"lang_status");
        try {
            for (ITableDto dto : dtoList) {
                ITableDto translation = (ITableDto)translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                FieldUtils.writeField((java.lang.reflect.Field)langStatusField, (Object)translation, (Object)PuiConstants.TRUE_INT, (boolean)true);
                this.getTableTranslationDao().insert(translation);
                String baseLang = (String)langField.get(translation);
                Iterator it = PuiLanguageUtils.getLanguagesIterator();
                while (it.hasNext()) {
                    PuiLanguage lang = (PuiLanguage)it.next();
                    if (lang.getIsocode().equals(baseLang)) continue;
                    translation = (ITableDto)translationClass.newInstance();
                    PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                    FieldUtils.writeField((java.lang.reflect.Field)langField, (Object)translation, (Object)lang.getIsocode(), (boolean)true);
                    FieldUtils.writeField((java.lang.reflect.Field)langStatusField, (Object)translation, (Object)PuiConstants.FALSE_INT, (boolean)true);
                    this.getTableTranslationDao().insert(translation);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void afterInsert(List<T> dtoList) {
        dtoList.forEach(dto -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.getDtoClass()))) {
                return;
            }
            this.threadDaoEvents.addEventType(new InsertDaoEvent((ITableDto)dto));
        });
    }

    @Override
    public T update(T dto) throws PuiDaoUpdateException {
        T oldDto;
        if (dto == null) {
            return null;
        }
        PuiLanguage lang = PuiLanguageUtils.getLanguage(dto);
        try {
            oldDto = this.findOne(dto.createPk(), lang);
        }
        catch (PuiDaoFindException e) {
            throw new PuiDaoUpdateException(e);
        }
        try {
            this.checkValues((ITableDto)dto);
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoUpdateException(e);
        }
        try {
            this.prepareUpdate(Collections.singletonList(dto));
            this.updateTranslations(Collections.singletonList(dto));
            this.afterUpdate(oldDto, Collections.singletonList(dto));
            return dto;
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
    }

    @Override
    public List<T> bulkUpdate(List<T> dtoList) throws PuiDaoUpdateException {
        if (dtoList == null) {
            return Collections.emptyList();
        }
        try {
            for (ITableDto dto : dtoList) {
                this.checkValues(dto);
            }
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoUpdateException(e);
        }
        try {
            this.prepareUpdate(dtoList);
            this.updateTranslations(dtoList);
            this.afterUpdate(null, dtoList);
            return dtoList;
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
    }

    protected void prepareUpdate(List<T> dtoList) throws DataAccessException {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames(this.getDtoClass()));
        columnNames.removeAll(DtoRegistry.getSequenceColumns(this.getDtoClass()));
        Table table = DSL.table((String)this.getEntityName());
        Map set = columnNames.stream().collect(Collectors.toMap(DSL::field, cn -> DSL.field((String)this.getParameterTextForColumnUpdate((String)cn)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        List condition = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        UpdateConditionStep update = this.dbHelper.getDSLContext().update(table).set(set).where(condition);
        this.executeUpdate(dtoList, update.getSQL());
    }

    protected String getParameterTextForColumnUpdate(String columnName) {
        return "?";
    }

    protected void executeUpdate(final List<T> dtoList, String sql) throws DataAccessException {
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames(this.getDtoClass()));
        columnNames.removeAll(DtoRegistry.getSequenceColumns(this.getDtoClass()));
        if (CollectionUtils.isEmpty(columnNames)) {
            return;
        }
        final Map map = DtoRegistry.getMapFieldsFromColumnName(this.getDtoClass());
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoList.size() == 1) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String columnName : columnNames) {
                Object val;
                java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                if (field == null) continue;
                try {
                    val = FieldUtils.readField((java.lang.reflect.Field)field, dtoList.get(0), (boolean)true);
                }
                catch (Exception e) {
                    continue;
                }
                if (val instanceof Instant) {
                    val = Timestamp.from((Instant)val);
                }
                val = this.modifyUpdateColumnValue((ITableDto)dtoList.get(0), columnName, val);
                values.add(val);
            }
            ITableDto dtoPk = ((ITableDto)dtoList.get(0)).createPk();
            for (String pkColumnName : pkColumnNames) {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                if (field == null) continue;
                try {
                    Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                    values.add(val);
                }
                catch (Exception e1) {
                    try {
                        Object val = FieldUtils.readField((java.lang.reflect.Field)field, dtoList.get(0), (boolean)true);
                        values.add(val);
                    }
                    catch (Exception exception) {}
                }
            }
            this.jdbcTemplate.update(sql, values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dto = (ITableDto)dtoList.get(i);
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object objValue;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            objValue = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (objValue instanceof Instant) {
                            objValue = Timestamp.from((Instant)objValue);
                        }
                        objValue = AbstractTableDao.this.modifyUpdateColumnValue(dto, columnName, objValue);
                        ps.setObject(nextParameter++, objValue);
                    }
                    ITableDto dtoPk = dto.createPk();
                    for (String pkColumnName : pkColumnNames) {
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                        if (field == null) continue;
                        try {
                            Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                            ps.setObject(nextParameter++, val);
                        }
                        catch (Exception e1) {
                            try {
                                Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                                ps.setObject(nextParameter++, val);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }

                public int getBatchSize() {
                    return dtoList.size();
                }
            });
        }
    }

    protected Object modifyUpdateColumnValue(T dto, String columnName, Object value) {
        return value;
    }

    private void updateTranslations(List<T> dtoList) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        try {
            for (ITableDto dto : dtoList) {
                ITableDto translation = (ITableDto)translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                this.getTableTranslationDao().update(translation);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void afterUpdate(T oldDto, List<T> dtoList) {
        dtoList.forEach(dto -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.getDtoClass()))) {
                return;
            }
            this.threadDaoEvents.addEventType(new UpdateDaoEvent((ITableDto)dto, (ITableDto)oldDto));
        });
    }

    @Override
    public TPK patch(TPK dtoPk, Map<String, Object> fieldValuesMap) throws PuiDaoSaveException {
        try {
            this.preparePatch(Collections.singletonList(dtoPk), fieldValuesMap);
            this.patchTranslations(Collections.singletonList(dtoPk), fieldValuesMap);
            this.afterPatch(Collections.singletonList(dtoPk), fieldValuesMap);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
        return dtoPk;
    }

    @Override
    public void bulkPatch(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) throws PuiDaoUpdateException {
        if (dtoPkList == null) {
            return;
        }
        try {
            this.preparePatch(dtoPkList, fieldValuesMap);
            this.patchTranslations(dtoPkList, fieldValuesMap);
            this.afterPatch(dtoPkList, fieldValuesMap);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
    }

    private void preparePatch(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        List dtoColumns = DtoRegistry.getColumnNames(this.getDtoClass());
        LinkedHashMap<String, Object> columnValuesMap = new LinkedHashMap<String, Object>();
        fieldValuesMap.forEach((fieldName, value) -> {
            String columnName = DtoRegistry.getColumnNameFromFieldName(this.getDtoClass(), (String)fieldName);
            if (columnName == null) {
                columnName = fieldName;
            }
            columnValuesMap.put(columnName, value);
        });
        columnValuesMap.keySet().removeIf(fieldName -> !dtoColumns.contains(fieldName));
        if (columnValuesMap.isEmpty()) {
            return;
        }
        Table table = DSL.table((String)this.getEntityName());
        Map set = columnValuesMap.keySet().stream().collect(Collectors.toMap(DSL::field, cn -> DSL.field((String)this.getParameterTextForColumnUpdate((String)cn)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        List where = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        UpdateConditionStep update = this.dbHelper.getDSLContext().update(table).set(set).where(where);
        this.executePatch(dtoPkList, columnValuesMap, update.getSQL());
    }

    private void executePatch(final List<TPK> dtoPkList, final Map<String, Object> columnValuesMap, String sql) {
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoPkList.size() == 1) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : columnValuesMap.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof Instant) {
                    val = Timestamp.from((Instant)val);
                }
                values.add(val);
            }
            for (String string : pkColumnNames) {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(string);
                if (field == null) continue;
                try {
                    Object val = FieldUtils.readField((java.lang.reflect.Field)field, dtoPkList.get(0), (boolean)true);
                    values.add(val);
                }
                catch (Exception exception) {}
            }
            this.jdbcTemplate.update(sql, values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    int nextParameter = 1;
                    for (Map.Entry next : columnValuesMap.entrySet()) {
                        Object val = next.getValue();
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        ps.setObject(nextParameter++, val);
                    }
                    ITableDto dtoPk = (ITableDto)dtoPkList.get(i);
                    for (String next : pkColumnNames) {
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(next);
                        if (field == null) continue;
                        try {
                            Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                            ps.setObject(nextParameter++, val);
                        }
                        catch (Exception exception) {}
                    }
                }

                public int getBatchSize() {
                    return dtoPkList.size();
                }
            });
        }
    }

    private void patchTranslations(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        for (ITableDto dtoPk : dtoPkList) {
            ITableDto translation;
            try {
                translation = (ITableDto)translationClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return;
            }
            PuiObjectUtils.copyProperties((Object)translation, (Object)dtoPk);
            PuiLanguage lang = fieldValuesMap.containsKey("lang") ? new PuiLanguage(fieldValuesMap.get("lang").toString()) : PuiUserSession.getSessionLanguage();
            PuiLanguageUtils.setLanguage((IDto)translation, (PuiLanguage)lang);
            this.getTableTranslationDao().patch(translation.createPk(), fieldValuesMap);
        }
    }

    protected void afterPatch(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) {
        dtoPkList.forEach(dtoPk -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.getDtoClass()))) {
                return;
            }
            this.threadDaoEvents.addEventType(new UpdateDaoEvent((ITableDto)dtoPk, fieldValuesMap));
        });
    }

    @Override
    public TPK delete(TPK dtoPk) throws PuiDaoDeleteException {
        try {
            this.deleteTranslations(Collections.singletonList(dtoPk));
            dtoPk = (ITableDto)this.prepareDelete(Collections.singletonList(dtoPk)).get(0);
            this.afterDelete(Collections.singletonList(dtoPk));
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
        return dtoPk;
    }

    @Override
    public List<TPK> bulkDelete(List<TPK> dtoPkList) throws PuiDaoDeleteException {
        if (dtoPkList == null) {
            return Collections.emptyList();
        }
        try {
            this.deleteTranslations(dtoPkList);
            dtoPkList = this.prepareDelete(dtoPkList);
            this.afterDelete(dtoPkList);
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
        return dtoPkList;
    }

    private void deleteTranslations(List<TPK> dtoPkList) throws PuiDaoDeleteException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class<ITableDto> translationClass = this.getTableTranslationDao().getDtoPkClass();
        try {
            FilterBuilder filter = FilterBuilder.newOrFilter();
            for (ITableDto dtoPk : dtoPkList) {
                ITableDto translation = translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dtoPk);
                FilterBuilder pkFilter = FilterBuilder.newAndFilter();
                DtoRegistry.getPkFields(this.getDtoPkClass()).forEach(pkField -> {
                    try {
                        Object value = FieldUtils.readField((java.lang.reflect.Field)DtoRegistry.getJavaFieldFromFieldName(this.getDtoPkClass(), (String)pkField), (Object)dtoPk, (boolean)true);
                        pkFilter.addEquals(pkField, value);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                });
                filter.addGroup(pkFilter);
            }
            this.getTableTranslationDao().deleteWhere(filter);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected List<TPK> prepareDelete(List<TPK> dtoPkList) throws DataAccessException {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Table table = DSL.table((String)this.getEntityName());
        List where = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        DeleteConditionStep delete = DSL.delete((Table)table).where(where);
        this.executeDelete(dtoPkList, delete.getSQL());
        return dtoPkList;
    }

    protected void executeDelete(final List<TPK> dtoPkList, String sql) throws DataAccessException {
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoPkList.size() == 1) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String pkColumnName : pkColumnNames) {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                if (field == null) continue;
                try {
                    Object value = FieldUtils.readField((java.lang.reflect.Field)field, dtoPkList.get(0), (boolean)true);
                    values.add(value);
                }
                catch (Exception exception) {}
            }
            this.jdbcTemplate.update(sql, values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dto = (ITableDto)dtoPkList.get(i);
                    int nextParameter = 1;
                    for (String pkColumnName : pkColumnNames) {
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                        if (field == null) continue;
                        try {
                            Object value = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                            ps.setObject(nextParameter++, value);
                        }
                        catch (Exception exception) {}
                    }
                }

                public int getBatchSize() {
                    return dtoPkList.size();
                }
            });
        }
    }

    protected void afterDelete(List<TPK> dtoPkList) {
        dtoPkList.forEach(dtoPk -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.getDtoClass()))) {
                return;
            }
            this.threadDaoEvents.addEventType(new DeleteDaoEvent((ITableDto)dtoPk));
        });
    }

    @Override
    public void deleteAll() throws PuiDaoDeleteException {
        this.deleteWhere(null);
    }

    @Override
    public void deleteAll(PuiLanguage language) throws PuiDaoDeleteException {
        this.deleteWhere(FilterBuilder.newAndFilter().addEquals("lang", (Object)language.getIsocode()));
    }

    @Override
    public void deleteWhere(FilterBuilder filterBuilder) throws PuiDaoDeleteException {
        Table table = DSL.table((String)this.getEntityName());
        DeleteUsingStep delete = DSL.delete((Table)table);
        if (filterBuilder != null) {
            String where = this.dbHelper.processFilters(this.getDtoClass(), filterBuilder.asFilterGroup(), false);
            delete.where(where);
        }
        this.executeDeleteWhere(delete.getSQL());
    }

    protected void executeDeleteWhere(String sql) throws PuiDaoDeleteException {
        try {
            this.jdbcTemplate.update(sql);
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
    }

    protected void checkValues(ITableDto dto) throws PuiDaoNullParametersException, PuiDaoAttributeLengthException {
        LinkedHashMap map = new LinkedHashMap();
        map.putAll(DtoRegistry.getMapFieldsFromFieldName(dto.getClass()));
        map.putAll(DtoRegistry.getLangMapFieldsFromFieldName(dto.getClass()));
        List notNullFieldNames = DtoRegistry.getNotNullFields(dto.getClass());
        for (String fieldName : notNullFieldNames) {
            Object value;
            java.lang.reflect.Field field;
            if (DtoRegistry.getSequenceFields(dto.getClass()).contains(fieldName) || (field = (java.lang.reflect.Field)map.get(fieldName)) == null) continue;
            try {
                value = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null) {
                throw new PuiDaoNullParametersException(fieldName);
            }
            if (!DtoRegistry.getStringFields(dto.getClass()).contains(fieldName) || !ObjectUtils.isEmpty((Object)value)) continue;
            throw new PuiDaoNullParametersException(fieldName);
        }
        Map maxLengthFieldNames = DtoRegistry.getFieldNamesMaxLength(dto.getClass());
        for (Map.Entry entry : maxLengthFieldNames.entrySet()) {
            String value;
            java.lang.reflect.Field field;
            String fieldName = (String)entry.getKey();
            Integer maxLength = (Integer)entry.getValue();
            if (maxLength.equals(-1) || (field = (java.lang.reflect.Field)map.get(fieldName)) == null || !field.getType().equals(String.class)) continue;
            try {
                value = (String)FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null || value.length() <= maxLength) continue;
            throw new PuiDaoAttributeLengthException(fieldName, maxLength, value.length());
        }
    }

    @Override
    public ITableDao<ITableDto, ITableDto> getTableTranslationDao() {
        if (this.tableTranslationDao == null && this.daoRegistry.hasLanguageSupport(this)) {
            Class daoLangClass = this.daoRegistry.getDaoFromEntityName(this.daoRegistry.getTableLangName(this), false);
            this.tableTranslationDao = (ITableDao)PuiApplicationContext.getInstance().getBean(daoLangClass);
        }
        return this.tableTranslationDao;
    }

    @Override
    protected void addTranslationJoins(SelectJoinStep<? extends Record> select) {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Field[] masterFields = pkColumnNames.stream().map(c -> DSL.field((Name)DSL.unquotedName((String[])new String[]{"t1", c}))).collect(Collectors.toList()).toArray(new Field[0]);
        Field[] relatedFields = pkColumnNames.stream().map(c -> DSL.field((Name)DSL.unquotedName((String[])new String[]{"t2", c}))).collect(Collectors.toList()).toArray(new Field[0]);
        select.leftJoin((TableLike)DSL.table((String)this.daoRegistry.getTableLangName(this)).as(DSL.unquotedName((String)"t2"))).on(DSL.row((Field[])masterFields).equal(relatedFields));
    }

    @Override
    public Class<? extends ITableDao<TPK, T>> getDaoClass() {
        return super.getDaoClass();
    }

    @Override
    public Class<TPK> getDtoPkClass() {
        if (ITableDto.class.isAssignableFrom(this.dtoClass)) {
            return this.dtoClass.getSuperclass();
        }
        return this.dtoClass;
    }
}

