/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.exceptions.PuiDaoCountException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoListException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.DaoRowMapper;
import es.prodevelop.pui9.model.dao.interfaces.IDao;
import es.prodevelop.pui9.model.dao.registry.DaoRegistry;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.order.Order;
import es.prodevelop.pui9.order.OrderBuilder;
import es.prodevelop.pui9.order.OrderDirection;
import es.prodevelop.pui9.search.SearchRequest;
import es.prodevelop.pui9.search.SearchResponse;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDao<T extends IDto>
implements IDao<T> {
    protected static final Log logger = LogFactory.getLog(AbstractDao.class);
    protected static final String PARAMETER = "?";
    @Autowired
    protected DaoRegistry daoRegistry;
    @Autowired
    protected IDatabaseHelper dbHelper;
    protected JdbcTemplate jdbcTemplate;
    protected Class<T> dtoClass;
    private DaoRowMapper<T> rowMapper;

    @Autowired
    private void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @PostConstruct
    private void postConstruct() {
        this.daoRegistry.registerDao(this.getClass());
        this.dtoClass = this.daoRegistry.getDtoFromDao(this.getClass(), false);
        this.rowMapper = this.getRowMapper();
    }

    protected DaoRowMapper<T> getRowMapper() {
        return new DaoRowMapper<T>(this, this.dtoClass);
    }

    protected String getEntityName() {
        return this.daoRegistry.getEntityName(this);
    }

    @Override
    public Long count() throws PuiDaoCountException {
        return this.count(null);
    }

    @Override
    public Long count(FilterBuilder filterBuilder) throws PuiDaoCountException {
        return this.count(null, false, filterBuilder);
    }

    @Override
    public Long count(String column, boolean distinct, FilterBuilder filterBuilder) throws PuiDaoCountException {
        SelectSelectStep count;
        if (!ObjectUtils.isEmpty((Object)column)) {
            String prefix = null;
            if (DtoRegistry.getAllColumnNames(this.getDtoClass()).contains(column)) {
                prefix = "t1";
            } else if (DtoRegistry.getLangColumnNames(this.getDtoClass()).contains(column)) {
                prefix = "t2";
            }
            if (prefix == null) {
                return null;
            }
            count = distinct ? this.dbHelper.getDSLContext().select((SelectField)DSL.countDistinct((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, column})))) : this.dbHelper.getDSLContext().select((SelectField)DSL.count((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, column}))));
        } else {
            count = this.dbHelper.getDSLContext().select((SelectField)DSL.count());
        }
        count.from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)((SelectJoinStep)count));
        }
        if (filterBuilder != null) {
            String filter = this.dbHelper.processFilters(this.getDtoClass(), filterBuilder.asFilterGroup(), true);
            count.where(filter);
        }
        return this.performCount((Select<Record1<Integer>>)count);
    }

    protected Long performCount(Select<Record1<Integer>> query) throws PuiDaoCountException {
        try {
            return (Long)this.jdbcTemplate.queryForObject(query.getSQL(), Long.class);
        }
        catch (DataAccessException e) {
            throw new PuiDaoCountException((Exception)((Object)e));
        }
    }

    @Override
    public T findOne(FilterBuilder filterBuilder) throws PuiDaoFindException {
        return this.findOne(filterBuilder, (PuiLanguage)null);
    }

    @Override
    public T findOne(FilterBuilder filterBuilder, OrderBuilder orderBuilder) throws PuiDaoFindException {
        List<T> list = this.doFindWhere(filterBuilder, orderBuilder, null);
        if (!list.isEmpty()) {
            return (T)((IDto)list.get(0));
        }
        return null;
    }

    @Override
    public T findOne(FilterBuilder filterBuilder, PuiLanguage language) throws PuiDaoFindException {
        List<T> list = this.doFindWhere(filterBuilder, null, language);
        if (!list.isEmpty()) {
            return (T)((IDto)list.get(0));
        }
        return null;
    }

    @Override
    public List<T> findAll() throws PuiDaoFindException {
        return this.doFindWhere(null, null, null);
    }

    @Override
    public List<T> findAll(OrderBuilder orderBuilder) throws PuiDaoFindException {
        return this.doFindWhere(null, orderBuilder, null);
    }

    @Override
    public List<T> findAll(PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(null, null, language);
    }

    @Override
    public List<T> findAll(OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(null, orderBuilder, language);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, null, null);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, orderBuilder, null);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, null, language);
    }

    @Override
    public List<T> findWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        return this.doFindWhere(filterBuilder, orderBuilder, language);
    }

    @Override
    public <N extends Number> N getNextValue(String columnName, FilterBuilder filterBuilder) throws PuiDaoNoNumericColumnException {
        Object value = this.getMaxValue(columnName, filterBuilder);
        if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).add(BigDecimal.ONE);
        } else if (value instanceof Integer) {
            value = (Integer)value + 1;
        } else if (value instanceof Long) {
            value = (Long)value + 1L;
        } else if (value instanceof Double) {
            value = (Double)value + 1.0;
        } else if (value instanceof Float) {
            value = Float.valueOf(((Float)value).floatValue() + 1.0f);
        } else if (value instanceof BigInteger) {
            value = ((BigInteger)value).add(BigInteger.ONE);
        }
        return value;
    }

    @Override
    public <N extends Number> N getMaxValue(String columnName, FilterBuilder filterBuilder) throws PuiDaoNoNumericColumnException {
        String filter;
        String auxFieldName = DtoRegistry.getFieldNameFromColumnName(this.getDtoClass(), (String)columnName);
        if (auxFieldName == null) {
            auxFieldName = columnName;
        }
        if (!DtoRegistry.getNumericFields(this.getDtoClass()).contains(auxFieldName) && !DtoRegistry.getFloatingFields(this.getDtoClass()).contains(auxFieldName)) {
            throw new PuiDaoNoNumericColumnException(columnName);
        }
        String auxColumnName = DtoRegistry.getColumnNameFromFieldName(this.getDtoClass(), (String)columnName);
        if (auxColumnName != null) {
            columnName = auxColumnName;
        }
        String prefix = null;
        if (DtoRegistry.getAllColumnNames(this.getDtoClass()).contains(columnName)) {
            prefix = "t1";
        } else if (DtoRegistry.getLangColumnNames(this.getDtoClass()).contains(columnName)) {
            prefix = "t2";
        }
        if (prefix == null) {
            return null;
        }
        SelectJoinStep max = this.dbHelper.getDSLContext().select((SelectField)DSL.max((Field)DSL.field((Name)DSL.unquotedName((String[])new String[]{prefix, columnName})))).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)max);
        }
        if (filterBuilder != null && !ObjectUtils.isEmpty((Object)(filter = this.dbHelper.processFilters(this.getDtoClass(), filterBuilder.asFilterGroup(), true)))) {
            max.where(filter);
        }
        String fieldName = DtoRegistry.getFieldNameFromColumnName(this.getDtoClass(), (String)columnName);
        java.lang.reflect.Field field = DtoRegistry.getJavaFieldFromFieldName(this.getDtoClass(), (String)fieldName);
        Number value = null;
        try {
            value = (Number)this.performMaxValue(max.getSQL(), field.getType());
        }
        catch (Exception e) {
            value = null;
        }
        if (value == null) {
            try {
                value = (Number)field.getType().getConstructor(String.class).newInstance("0");
            }
            catch (Exception e) {
                return null;
            }
        }
        return (N)value;
    }

    protected <N extends Number> N performMaxValue(String sql, Class<?> fieldType) {
        return (N)((Number)this.jdbcTemplate.queryForObject(sql, fieldType));
    }

    @Override
    public void executeQuery(Query query) throws PuiDaoFindException {
        if (query == null) {
            return;
        }
        try {
            this.jdbcTemplate.execute(query.getSQL());
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public List<T> executeCustomQuery(Query query) throws PuiDaoFindException {
        if (query == null) {
            return Collections.emptyList();
        }
        try {
            return this.jdbcTemplate.query(query.getSQL(), this.rowMapper);
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public List<T> executeCustomQueryWithParameters(Query query, List<Object> parameters) throws PuiDaoFindException {
        if (query == null) {
            return Collections.emptyList();
        }
        try {
            return this.jdbcTemplate.query(query.getSQL(), this.rowMapper, parameters.toArray());
        }
        catch (DataAccessException e) {
            throw new PuiDaoFindException((Exception)((Object)e));
        }
    }

    @Override
    public void executePaginagedOperation(SearchRequest req, Consumer<T> consumer, Consumer<List<T>> bulkConsumer) {
        req.setPage(SearchRequest.DEFAULT_PAGE);
        req.setPerformCount(false);
        req.setDtoClass(this.getDtoClass());
        while (true) {
            List list;
            try {
                list = this.findPaginated(req).getData();
            }
            catch (PuiDaoListException e) {
                list = Collections.emptyList();
            }
            if (CollectionUtils.isEmpty((Collection)list)) break;
            if (consumer != null) {
                for (IDto obj : list) {
                    consumer.accept(obj);
                }
            } else if (bulkConsumer != null) {
                bulkConsumer.accept(list);
            }
            req.setPage(Integer.valueOf(req.getPage() + 1));
        }
    }

    @Override
    public SearchResponse<T> findPaginated(SearchRequest req) throws PuiDaoListException {
        if (req.isFromClient() && PuiUserSession.getCurrentSession() != null) {
            req.setZoneId(PuiUserSession.getCurrentSession().getZoneId());
        }
        FilterBuilder filterBuilder = req.buildSearchFilter(this.getDtoClass());
        OrderBuilder orderBuilder = req.createOrderForSearch();
        if (!ObjectUtils.isEmpty((Object)req.getQueryLang()) && PuiLanguageUtils.hasLanguageSupport(this.getDtoClass())) {
            FilterBuilder langBuilder = FilterBuilder.newOrFilter().addEqualsExact("lang", req.getQueryLang()).addIsNull("lang");
            FilterBuilder filterBuilderAux = filterBuilder;
            filterBuilder = FilterBuilder.newAndFilter();
            filterBuilder.addGroup(langBuilder);
            filterBuilder.addGroup(filterBuilderAux);
        }
        String filters = this.dbHelper.processFilters(this.getDtoClass(), filterBuilder.asFilterGroup(), true);
        String quickSearch = null;
        if (!CollectionUtils.isEmpty((Collection)req.getQueryFields())) {
            quickSearch = this.dbHelper.processSearchText(this.getDtoClass(), req.getQueryFields(), req.getQueryText(), req.getZoneId());
        } else if (!CollectionUtils.isEmpty((Map)req.getQueryFieldText())) {
            quickSearch = this.dbHelper.processSearchText(this.getDtoClass(), req.getQueryFieldText(), req.getZoneId());
        }
        String where = ObjectUtils.isEmpty((Object)filters) && ObjectUtils.isEmpty(quickSearch) ? null : (!ObjectUtils.isEmpty((Object)filters) && ObjectUtils.isEmpty((Object)quickSearch) ? filters : (ObjectUtils.isEmpty((Object)filters) && !ObjectUtils.isEmpty((Object)quickSearch) ? quickSearch : "(" + filters + ") AND (" + quickSearch + ")"));
        SelectSelectStep select = CollectionUtils.isEmpty((Collection)req.getColumns()) ? this.dbHelper.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.asterisk()}) : (req.isDistinctValues() && req.getColumns().size() == 1 ? this.dbHelper.getDSLContext().selectDistinct((SelectField)DSL.field((String)((String)req.getColumns().get(0)))) : this.dbHelper.getDSLContext().select((Collection)req.getColumns().stream().map(DSL::field).collect(Collectors.toList())));
        select.from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)((SelectJoinStep)select));
        }
        if (!ObjectUtils.isEmpty((Object)where)) {
            select.where(where);
        }
        if (orderBuilder != null && !ObjectUtils.isEmpty((Object)orderBuilder.toString())) {
            Iterator it = orderBuilder.getOrders().iterator();
            while (it.hasNext()) {
                if (DtoRegistry.getAllColumnNames(this.dtoClass).contains(((Order)it.next()).getColumn())) continue;
                it.remove();
            }
            if (this.daoRegistry.hasLanguageSupport(this)) {
                orderBuilder.getOrders().forEach(order -> {
                    String column = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)order.getColumn());
                    if (column == null) {
                        return;
                    }
                    if (DtoRegistry.getColumnNames(this.dtoClass).contains(column)) {
                        order.setColumn("t1." + column);
                    } else {
                        order.setColumn("t2." + column);
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orderBuilder.getOrders())) {
                select.orderBy((Collection)orderBuilder.getOrders().stream().map(o -> o.getDirection().equals((Object)OrderDirection.asc) ? DSL.field((String)o.getColumn()).asc() : DSL.field((String)o.getColumn()).desc()).collect(Collectors.toList()));
            }
        }
        Long total = 0L;
        if (req.isPerformCount()) {
            SelectJoinStep count = DSL.select((SelectField)DSL.count((SelectFieldOrAsterisk)DSL.asterisk())).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
            if (this.daoRegistry.hasLanguageSupport(this)) {
                this.addTranslationJoins((SelectJoinStep<Record>)count);
            }
            if (!ObjectUtils.isEmpty((Object)where)) {
                count.where(where);
            }
            try {
                total = this.performCount((Select<Record1<Integer>>)count);
            }
            catch (PuiDaoCountException e) {
                throw new PuiDaoListException((Exception)((Object)e));
            }
        }
        Integer from = req.getPage() - 1;
        Integer size = req.getRows();
        List<T> list = this.getListPaginated(from, size, (SelectJoinStep)select);
        SearchResponse res = new SearchResponse();
        res.setCurrentPage(Integer.valueOf(from + 1));
        res.setCurrentRecords(Integer.valueOf(list.size()));
        res.setTotalRecords(total);
        res.setTotalPages(Long.valueOf(total / (long)size.intValue()));
        if (total % (long)size.intValue() > 0L) {
            res.setTotalPages(Long.valueOf(res.getTotalPages() + 1L));
        }
        res.setData(list);
        return res;
    }

    protected List<T> doFindWhere(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) throws PuiDaoFindException {
        Select<Record> query = this.buildSelectSql(filterBuilder, orderBuilder, language);
        return this.executeCustomQuery((Query)query);
    }

    private Select<Record> buildSelectSql(FilterBuilder filterBuilder, OrderBuilder orderBuilder, PuiLanguage language) {
        String filter;
        java.lang.reflect.Field field;
        SelectJoinStep select = this.dbHelper.getDSLContext().select(new SelectFieldOrAsterisk[]{DSL.asterisk()}).from((TableLike)DSL.table((String)this.getEntityName()).as(DSL.unquotedName((String)"t1")));
        if (this.daoRegistry.hasLanguageSupport(this)) {
            this.addTranslationJoins((SelectJoinStep<Record>)select);
        }
        if ((field = DtoRegistry.getJavaFieldFromAllFields(this.getDtoClass(), (String)"lang")) != null && language != null && PuiLanguageUtils.hasLanguageSupport(this.getDtoClass())) {
            FilterBuilder langFb = FilterBuilder.newOrFilter().addEquals("lang", (Object)language.getIsocode()).addIsNull("lang");
            FilterBuilder auxFb = filterBuilder;
            filterBuilder = FilterBuilder.newAndFilter().addGroup(auxFb).addGroup(langFb);
        }
        if (filterBuilder != null && !ObjectUtils.isEmpty((Object)(filter = this.dbHelper.processFilters(this.getDtoClass(), filterBuilder.asFilterGroup(), true)))) {
            select.where(filter);
        }
        if (orderBuilder != null && !ObjectUtils.isEmpty((Object)orderBuilder.toString())) {
            Iterator it = orderBuilder.getOrders().iterator();
            while (it.hasNext()) {
                if (DtoRegistry.getAllColumnNames(this.dtoClass).contains(((Order)it.next()).getColumn())) continue;
                it.remove();
            }
            if (this.daoRegistry.hasLanguageSupport(this)) {
                orderBuilder.getOrders().forEach(order -> {
                    String column = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)order.getColumn());
                    if (column != null) {
                        order.setColumn(column);
                    }
                    if (DtoRegistry.getColumnNames(this.dtoClass).contains(column)) {
                        order.setColumn("t1." + column);
                    } else {
                        order.setColumn("t2." + column);
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)orderBuilder.getOrders())) {
                select.orderBy((Collection)orderBuilder.getOrders().stream().map(o -> o.getDirection().equals((Object)OrderDirection.asc) ? DSL.field((String)o.getColumn()).asc() : DSL.field((String)o.getColumn()).desc()).collect(Collectors.toList()));
            }
        }
        return select;
    }

    protected void addTranslationJoins(SelectJoinStep<? extends Record> step) {
    }

    protected List<T> findByColumn(String fieldName, Object value) throws PuiDaoFindException {
        return this.findByColumn(fieldName, value, PuiUserSession.getSessionLanguage());
    }

    protected List<T> findByColumn(String fieldName, Object value, PuiLanguage language) throws PuiDaoFindException {
        String columnName = DtoRegistry.getColumnNameFromFieldName(this.dtoClass, (String)fieldName);
        FilterBuilder filterBuilder = FilterBuilder.newAndFilter();
        if (DtoRegistry.getStringFields(this.dtoClass).contains(fieldName) && value instanceof String) {
            filterBuilder.addEqualsExact(columnName, (String)value);
        } else {
            filterBuilder.addEquals(columnName, value);
        }
        return this.findWhere(filterBuilder, language);
    }

    private <S extends SelectJoinStep<Record>> List<T> getListPaginated(int page, int size, S select) throws PuiDaoListException {
        S newSelect = this.dbHelper.getSqlForPagination(page, size, select);
        return this.performListPaginated(newSelect);
    }

    protected <S extends SelectJoinStep<Record>> List<T> performListPaginated(S select) throws PuiDaoListException {
        try {
            return this.jdbcTemplate.query(select.getSQL(), this.rowMapper);
        }
        catch (DataAccessException e) {
            throw new PuiDaoListException((Exception)((Object)e));
        }
    }

    protected void customizeDto(T dto) {
    }

    @Override
    public Class<T> getDtoClass() {
        return this.dtoClass;
    }

    @Override
    public Class<? extends IDao<T>> getDaoClass() {
        return this.getClass();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

