/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.login;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.enums.Pui9KnownClients;
import es.prodevelop.pui9.eventlistener.PuiEventLauncher;
import es.prodevelop.pui9.eventlistener.event.ModifySessionPropertyEvent;
import es.prodevelop.pui9.lang.LanguageThreadLocal;
import es.prodevelop.pui9.login.PasswordValidity;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class PuiUserSession
implements UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = 1L;
    private String usr;
    private String uuid;
    private transient String password;
    private String name;
    private PuiLanguage language;
    private String email;
    private String jwt;
    private Instant creation;
    private Instant expiration;
    private List<String> profiles = new ArrayList<String>();
    private boolean persistent;
    private boolean cached = true;
    private String ip;
    private String userAgent;
    private String client;
    private String dateformat;
    private Instant lastLoginTime;
    private String lastLoginIp;
    private PasswordValidity passwordValidity;
    private boolean use2fa;
    private String secret2fa;
    private Integer attemps2fa = 0;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private transient List<PuiUserSessionProfile> fullProfiles = new ArrayList<PuiUserSessionProfile>();
    private transient List<PuiUserSessionFunctionality> fullFunctionalities = new ArrayList<PuiUserSessionFunctionality>();
    private transient List<String> functionalities = new ArrayList<String>();
    private transient List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private transient boolean authenticated;
    private transient boolean disabled;
    private transient boolean accountExpired;
    private transient boolean accountLocked;
    private transient boolean credentialsExpired;
    private transient ZoneId zoneId;
    private transient Instant lastUse;

    public static PuiUserSession getCurrentSession() {
        return SecurityContextHolder.getContext().getAuthentication() != null ? (PuiUserSession)SecurityContextHolder.getContext().getAuthentication().getPrincipal() : null;
    }

    public static PuiLanguage getSessionLanguage() {
        return PuiUserSession.getCurrentSession() != null ? PuiUserSession.getCurrentSession().getLanguage() : (LanguageThreadLocal.getSingleton().getData() != null ? LanguageThreadLocal.getSingleton().getData() : (PuiLanguageUtils.getDefaultLanguage() != null ? PuiLanguageUtils.getDefaultLanguage() : PuiLanguage.DEFAULT_LANG));
    }

    public static PuiUserSession createNew(String usr) {
        return new PuiUserSession().withUsr(usr);
    }

    private PuiUserSession() {
    }

    public PuiUserSession withUsr(String usr) {
        this.usr = usr;
        return this;
    }

    public PuiUserSession withName(String name) {
        this.name = name;
        return this;
    }

    public PuiUserSession withPassword(String password) {
        this.password = password;
        return this;
    }

    public PuiUserSession withLanguage(PuiLanguage language) {
        this.language = language;
        return this;
    }

    public PuiUserSession withEmail(String email) {
        this.email = email;
        return this;
    }

    public PuiUserSession withDateFormat(String dateformat) {
        this.dateformat = dateformat;
        return this;
    }

    public PuiUserSession withDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public PuiUserSession withAccountExpired(boolean accountExpired) {
        this.accountExpired = accountExpired;
        return this;
    }

    public PuiUserSession withAccountLocked(boolean accountLocked) {
        this.accountLocked = accountLocked;
        return this;
    }

    public PuiUserSession withCredentialsExpired(boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
        return this;
    }

    public PuiUserSession withLastLoginTime(Instant lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return this;
    }

    public PuiUserSession withLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
        return this;
    }

    public PuiUserSession withPasswordValidity(PasswordValidity passwordValidity) {
        this.passwordValidity = passwordValidity;
        return this;
    }

    public PuiUserSession withUse2fa(boolean use2fa) {
        this.use2fa = use2fa;
        return this;
    }

    public PuiUserSession withSecret2fa(String secret2fa) {
        this.secret2fa = secret2fa;
        return this;
    }

    public PuiUserSession withAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public PuiUserSession withCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public PuiUserSession withCreation(Instant creation) {
        this.creation = creation;
        return this;
    }

    public PuiUserSession withUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public PuiUserSession withJwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    public PuiUserSession withPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public PuiUserSession withExpiration(Instant expiration) {
        this.expiration = expiration;
        return this;
    }

    public PuiUserSession withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public PuiUserSession withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public PuiUserSession withClient(String client) {
        this.client = client;
        return this;
    }

    public PuiUserSession withZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public PuiUserSession withLastUse(Instant lastUse) {
        this.lastUse = lastUse;
        return this;
    }

    public PuiUserSession withProperty(String property, Object value) {
        Object oldValue = this.properties.put(property, value);
        PuiApplicationContext.getInstance().getBean(PuiEventLauncher.class).fireSync(new ModifySessionPropertyEvent(property, oldValue, value));
        return this;
    }

    public String getUsr() {
        return this.usr;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public PuiLanguage getLanguage() {
        return this.language;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<PuiUserSessionProfile> getFullProfiles() {
        return this.fullProfiles;
    }

    public void setFullProfiles(List<PuiUserSessionProfile> profiles) {
        Collections.sort(profiles);
        this.fullProfiles.clear();
        this.fullProfiles.addAll(profiles);
        this.setProfiles(profiles);
    }

    public List<PuiUserSessionFunctionality> getFullFunctionalities() {
        return this.fullFunctionalities;
    }

    public void setFullFunctionalities(List<PuiUserSessionFunctionality> functionalities) {
        Collections.sort(functionalities);
        this.fullFunctionalities.clear();
        this.fullFunctionalities.addAll(functionalities);
        this.setFunctionalities(functionalities);
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<PuiUserSessionProfile> profiles) {
        Collections.sort(profiles);
        this.profiles.clear();
        profiles.forEach(p -> this.profiles.add(p.getProfile()));
    }

    public List<String> getFunctionalities() {
        return this.functionalities;
    }

    public void setFunctionalities(List<PuiUserSessionFunctionality> functionalities) {
        Collections.sort(functionalities);
        this.functionalities.clear();
        this.authorities.clear();
        functionalities.forEach(f -> {
            if (!this.functionalities.contains(f.getFunctionality())) {
                this.functionalities.add(f.getFunctionality());
                this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(f.getFunctionality()));
            }
        });
    }

    public String getJwt() {
        return this.jwt;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClient() {
        return this.client;
    }

    public ZoneId getZoneId() {
        return this.zoneId != null ? this.zoneId : ZoneId.systemDefault();
    }

    public Instant getLastUse() {
        return this.lastUse;
    }

    public String getUsername() {
        return this.getUsr();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isAccountNonExpired() {
        return !this.accountExpired;
    }

    public boolean isAccountNonLocked() {
        return !this.accountLocked;
    }

    public boolean isCredentialsNonExpired() {
        return !this.credentialsExpired;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void eraseCredentials() {
        this.password = null;
        this.authorities.clear();
    }

    public Instant getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public PasswordValidity getPasswordValidity() {
        return this.passwordValidity;
    }

    public boolean isUse2fa() {
        return this.use2fa;
    }

    public String getSecret2fa() {
        return this.secret2fa;
    }

    public void incrementAttempts2fa() {
        Integer n = this.attemps2fa;
        Integer n2 = this.attemps2fa = Integer.valueOf(this.attemps2fa + 1);
    }

    public Integer getAttemps2fa() {
        return this.attemps2fa;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getProperty(String property) {
        return (T)this.properties.get(property);
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isPui9Client() {
        return Objects.equals(this.client, Pui9KnownClients.PUI9_CLIENT.name());
    }

    public static class PuiUserSessionFunctionality
    implements Comparable<PuiUserSessionFunctionality> {
        private String profile;
        private String functionality;

        public static PuiUserSessionFunctionality createNewFunctionality(String profile, String functionality) {
            PuiUserSessionFunctionality func = new PuiUserSessionFunctionality();
            func.profile = profile;
            func.functionality = functionality;
            return func;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getFunctionality() {
            return this.functionality;
        }

        public String toString() {
            return this.functionality + " (" + this.profile + ")";
        }

        @Override
        public int compareTo(PuiUserSessionFunctionality o) {
            return this.functionality.compareTo(o.getFunctionality());
        }
    }

    public static class PuiUserSessionProfile
    implements Comparable<PuiUserSessionProfile> {
        private String profile;

        public static PuiUserSessionProfile createNewProfile(String profile) {
            PuiUserSessionProfile prof = new PuiUserSessionProfile();
            prof.profile = profile;
            return prof;
        }

        public String getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.profile;
        }

        @Override
        public int compareTo(PuiUserSessionProfile o) {
            return this.profile.compareTo(o.getProfile());
        }
    }
}

