/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.login;

import es.prodevelop.pui9.login.PasswordValidity;
import es.prodevelop.pui9.utils.IPuiObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PuiUserInfo
implements IPuiObject {
    private static final long serialVersionUID = 1L;
    private String usr;
    private String name;
    private String language;
    private String email;
    private String dateformat;
    private String jwt;
    private String uuid;
    private Instant lastLoginTime;
    private String lastLoginIp;
    private PasswordValidity passwordValidity;
    private boolean use2fa;
    private List<String> profiles = new ArrayList<String>();
    private List<String> functionalities = new ArrayList<String>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static PuiUserInfo forUser(String usr) {
        return new PuiUserInfo(usr);
    }

    private PuiUserInfo(String usr) {
        this.usr = usr;
    }

    public PuiUserInfo withName(String name) {
        this.name = name;
        return this;
    }

    public PuiUserInfo withLanguage(String language) {
        this.language = language;
        return this;
    }

    public PuiUserInfo withEmail(String email) {
        this.email = email;
        return this;
    }

    public PuiUserInfo withDateFormat(String dateformat) {
        this.dateformat = dateformat;
        return this;
    }

    public PuiUserInfo withJwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    public PuiUserInfo withUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public PuiUserInfo withLastLoginTime(Instant lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return this;
    }

    public PuiUserInfo withLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
        return this;
    }

    public PuiUserInfo with2fa(boolean use2fa) {
        this.use2fa = use2fa;
        return this;
    }

    public PuiUserInfo withPasswordValidity(PasswordValidity passwordValidity) {
        this.passwordValidity = passwordValidity;
        return this;
    }

    public PuiUserInfo withProfiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public PuiUserInfo withFunctionalities(List<String> functionalities) {
        this.functionalities = functionalities;
        return this;
    }

    public String getUsr() {
        return this.usr;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public String getJwt() {
        return this.jwt;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Instant getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public PasswordValidity getPasswordValidity() {
        return this.passwordValidity;
    }

    public boolean is2fa() {
        return this.use2fa;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    public List<String> getFunctionalities() {
        return this.functionalities;
    }

    public void addProperty(String property, Object value) {
        this.properties.put(property, value);
    }
}

