/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.components;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class PuiApplicationContext {
    private static PuiApplicationContext puiContext;
    @Autowired
    private ApplicationContext appContext;

    public static PuiApplicationContext getInstance() {
        Assert.notNull((Object)puiContext, (String)"PuiApplicationContext should be used once the bean is created by Spring");
        return puiContext;
    }

    private PuiApplicationContext() {
    }

    @PostConstruct
    private void postConstruct() {
        puiContext = this;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public <T> T getBean(Class<T> beanClass) {
        if (beanClass == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = this.appContext.getBean(beanClass);
        }
        catch (NoUniqueBeanDefinitionException e) {
            Map list = this.appContext.getBeansOfType(beanClass);
            if (list.isEmpty()) {
                return null;
            }
            bean = list.get(StringUtils.uncapitalize((String)beanClass.getSimpleName()));
        }
        return (T)bean;
    }

    public <T> T getBean(Class<T> beanClass, Class<?> genericClass) {
        if (beanClass == null || genericClass == null) {
            return null;
        }
        Object bean = null;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(beanClass, (Class[])new Class[]{genericClass});
        String[] names = this.appContext.getBeanNamesForType(resolvableType);
        if (names.length > 0) {
            try {
                bean = this.appContext.getBean(names[0]);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return (T)bean;
    }
}

