package es.prodevelop.pui9.db.helpers;

import java.util.Collection;
import java.util.stream.Collectors;

import org.springframework.stereotype.Component;

/**
 * Database Helper for PostgreSql. Concret implementation of Abstract Database
 * Helper
 * 
 * @author Marc Gil - mgil@prodevelop.es
 */
@Component
public class PostgreSqlDatabaseHelper extends AbstractDatabaseHelper {

	private static final String DATE_TIME_FORMAT = DATE_FORMAT + " HH24:MI:SS";
	private static final String POSTGRESQL_DATE_TIME_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.MS\"Z\"";

	@Override
	protected String getSqlCastToString() {
		return "CAST(" + COLUMNNAME + " AS VARCHAR)";
	}

	protected String getSqlConvertDateIntoString() {
		return "TO_CHAR(" + COLUMNNAME + " at time zone '" + TIMEZONE + "', '" + adaptDateFormatToUser(DATE_TIME_FORMAT)
				+ "')";
	}

	protected String getSqlConvertStringIntoDate() {
		return "TO_TIMESTAMP('" + VALUE + "', '" + POSTGRESQL_DATE_TIME_FORMAT + "')";
	}

	@Override
	protected String getSqlTextOperation(boolean caseSensitiveAndAccents, boolean isLargeStringField,
			boolean dataIsColumn) {
		if (dataIsColumn) {
			return COLUMNNAME + " " + OP + " '" + BEGINNING + "' || " + VALUE + " || '" + END + "'";
		} else {
			if (caseSensitiveAndAccents) {
				return COLUMNNAME + " " + OP + " '" + BEGINNING + "' || '" + VALUE + "' || '" + END + "'";
			} else {
				return "UNACCENT(LOWER(" + COLUMNNAME + ")) " + OP + " '" + BEGINNING + "' || UNACCENT(LOWER('" + VALUE
						+ "')) || '" + END + "'";
			}
		}
	}

	@Override
	public String getSqlForPagination(int page, int size, String query) {
		StringBuilder sb = new StringBuilder();

		int from = page * size;

		sb.append(query + " \n");
		sb.append("limit " + size + " offset " + from);

		return sb.toString();
	}

	@Override
	public String getViewsSql(Collection<String> viewNames) {
		StringBuilder sb = new StringBuilder();
		sb.append("select table_name, view_definition ");
		sb.append("from information_schema.views ");
		sb.append("where table_schema = any(current_schemas(false)) ");
		sb.append("and table_name in (" + viewNames.stream().collect(Collectors.joining("','", "'", "'")) + ")");
		return sb.toString();
	}

}
