/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.db.helpers;

import es.prodevelop.pui9.db.helpers.AbstractDatabaseHelper;
import org.springframework.stereotype.Component;

@Component
public class OracleDatabaseHelper
extends AbstractDatabaseHelper {
    private static final String DATE_TIME_FORMAT = "{DATE_FORMAT}\"T\"HH24:MI:SS\"Z\"";
    private static final String ORACLE_DATE_TIME_FORMAT = "YYYY-MM-DD\"T\"HH24:MI:SS.FF3\"Z\"";

    protected String getSqlCastToString() {
        return "TO_CHAR(_columnname_)";
    }

    protected String getSqlConvertDateIntoString() {
        return "TO_CHAR(_columnname_, '" + this.adaptDateFormatToUser(DATE_TIME_FORMAT) + "')";
    }

    protected String getSqlConvertStringIntoDate() {
        return "TO_TIMESTAMP('_value_', 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3\"Z\"')";
    }

    protected String getSqlTextOperation(boolean isLargeStringField) {
        if (!isLargeStringField) {
            return "TRANSLATE(LOWER(_columnname_), '\u00e1\u00e9\u00ed\u00f3\u00fa\u00e8\u00f2', 'aeioueo') _op_ '_beginning_' || TRANSLATE(LOWER('_value_'),'\u00e1\u00e9\u00ed\u00f3\u00fa\u00e8\u00f2','aeioueo') || '_end_'";
        }
        return "LOWER(_columnname_) _op_ '_beginning_' || TRANSLATE(LOWER('_value_'),'\u00e1\u00e9\u00ed\u00f3\u00fa\u00e8\u00f2','aeioueo') || '_end_'";
    }

    public String getSqlForPagination(int page, int size, String query) {
        StringBuilder sb = new StringBuilder();
        int from = page * size + 1;
        int to = from + size - 1;
        sb.append("select * \n");
        sb.append("from ( \n");
        sb.append("select rownum rnum, a.* \n");
        sb.append("from ( \n");
        sb.append(query + "\n");
        sb.append(") a \n");
        sb.append("where rownum <= " + to + " \n");
        sb.append(") \n");
        sb.append("where rnum >= " + from);
        return sb.toString();
    }

    public String getViewsSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("select view_name, text ");
        sb.append("from SYS.USER_VIEWS");
        return sb.toString();
    }
}

