/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.geo.helpers;

import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.geo.dao.helpers.IDatabaseGeoHelper;
import es.prodevelop.pui9.geo.filter.rules.AbstractBoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.AbstractIntersectsByPoint2DRule;
import es.prodevelop.pui9.geo.filter.rules.BoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.IntersectsByPoint2DRule;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class SqlServerDatabaseGeoHelper
implements IDatabaseGeoHelper {
    @Autowired
    private IDatabaseHelper dbHelper;
    private JdbcTemplate jdbcTemplate;
    private Integer srid;

    public Integer getSrid() {
        if (this.srid == null) {
            SelectConditionStep select = this.dbHelper.getDSLContext().select((SelectField)DSL.field((Name)DSL.unquotedName((String[])new String[]{"t", "name"})).as("entity"), (SelectField)DSL.field((Name)DSL.unquotedName((String[])new String[]{"c", "name"})).as("columnname")).from((TableLike)DSL.table((Name)DSL.unquotedName((String[])new String[]{"sys", "columns"})).as("c")).join((TableLike)DSL.table((Name)DSL.unquotedName((String[])new String[]{"sys", "tables"})).as("t")).on(DSL.field((Name)DSL.unquotedName((String[])new String[]{"t", "object_id"})).eq(DSL.field((Name)DSL.unquotedName((String[])new String[]{"c", "object_id"})))).where(DSL.function((Name)DSL.unquotedName((String)"type_name"), Object.class, (Field[])new Field[]{DSL.field((String)"user_type_id")}).eq((Object)DSL.inline((String)"geometry")));
            List res = this.jdbcTemplate.queryForList(select.getSQL());
            block0: for (Map map : res) {
                String entity = (String)map.get("entity");
                String columnname = (String)map.get("columnname");
                SelectJoinStep select2 = this.dbHelper.getDSLContext().select((SelectField)DSL.field((Name)DSL.name((Name[])new Name[]{DSL.unquotedName((String)("top 1 " + columnname)), DSL.unquotedName((String)"STSrid")})).as("srid")).from(entity);
                List res2 = this.jdbcTemplate.queryForList(select2.getSQL());
                for (Map map2 : res2) {
                    if (!map2.containsKey("srid")) continue;
                    this.srid = (Integer)map.get("srid");
                    if (this.srid == null || this.srid <= 0) continue;
                    continue block0;
                }
            }
        }
        return this.srid;
    }

    public String modifyColumnValue(String value) {
        return DSL.function((String)"geometry::ST_GeomFromText", Object.class, (Field[])new Field[]{DSL.inline((String)value), DSL.inline((Integer)this.getSrid())}).toString();
    }

    public Field<Object> fillGeometryValue(String geoColumnName) {
        return DSL.field((Name)DSL.name((Name[])new Name[]{DSL.unquotedName((String)geoColumnName), DSL.unquotedName((String)"STAsText()")})).as(DSL.unquotedName((String)geoColumnName));
    }

    public void setGeometryValue(Geometry jtsGeometry, int geometryDimension, PreparedStatement ps, int position) throws SQLException {
        ps.setString(position, jtsGeometry.toString());
    }

    public boolean supportsNativeGeometry() {
        return false;
    }

    public AbstractBoundingBoxRule createBoundingBoxRule(String column, Double xmin, Double ymin, Double xmax, Double ymax) {
        return BoundingBoxRule.of(column, this.getSrid(), xmin, ymin, xmax, ymax);
    }

    public AbstractIntersectsByPoint2DRule createIntersectsByPoint2DRule(String column, Double x, Double y) {
        return IntersectsByPoint2DRule.of(column, this.getSrid(), x, y);
    }
}

