package es.prodevelop.pui9.geo.helpers;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.geo.dao.helpers.IDatabaseGeoHelper;
import es.prodevelop.pui9.geo.filter.rules.AbstractBoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.AbstractIntersectsByPoint2DRule;
import es.prodevelop.pui9.geo.filter.rules.BoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.IntersectsByPoint2DRule;

@Component
public class SqlServerDatabaseGeoHelper implements IDatabaseGeoHelper {

	@Autowired
	private IDatabaseHelper dbHelper;

	private JdbcTemplate jdbcTemplate;
	private Integer srid;

	public Integer getSrid() {
		if (srid == null) {
			SelectConditionStep<Record2<Object, Object>> select = dbHelper.getDSLContext()
					.select(DSL.field(DSL.unquotedName("t", "name")).as("entity"),
							DSL.field(DSL.unquotedName("c", "name")).as("columnname"))
					.from(DSL.table(DSL.unquotedName("sys", "columns")).as("c"))
					.join(DSL.table(DSL.unquotedName("sys", "tables")).as("t"))
					.on(DSL.field(DSL.unquotedName("t", "object_id")).eq(DSL.field(DSL.unquotedName("c", "object_id"))))
					.where(DSL.function(DSL.unquotedName("type_name"), Object.class, DSL.field("user_type_id"))
							.eq(DSL.inline("geometry")));

			List<Map<String, Object>> res = jdbcTemplate.queryForList(select.getSQL());
			for (Map<String, Object> map : res) {
				String entity = (String) map.get("entity");
				String columnname = (String) map.get("columnname");

				Select<Record1<Object>> select2 = dbHelper.getDSLContext().select(DSL
						.field(DSL.name(DSL.unquotedName("top 1 " + columnname), DSL.unquotedName("STSrid"))).as(SRID))
						.from(entity);

				List<Map<String, Object>> res2 = jdbcTemplate.queryForList(select2.getSQL());
				for (Map<String, Object> map2 : res2) {
					if (map2.containsKey(SRID)) {
						srid = (Integer) map.get(SRID);
						if (srid != null && srid > 0) {
							break;
						}
					}
				}
			}
		}
		return srid;
	}

	@Override
	public String modifyColumnValue(String value) {
		return DSL.function("geometry::ST_GeomFromText", Object.class, DSL.inline(value), DSL.inline(getSrid()))
				.toString();
	}

	@Override
	public Field<Object> fillGeometryValue(String geoColumnName) {
		return DSL.field(DSL.name(DSL.unquotedName(geoColumnName), DSL.unquotedName("STAsText()")))
				.as(DSL.unquotedName(geoColumnName));
	}

	@Override
	public void setGeometryValue(Geometry jtsGeometry, int geometryDimension, PreparedStatement ps, int position)
			throws SQLException {
		ps.setString(position, jtsGeometry.toString());
	}

	@Override
	public boolean supportsNativeGeometry() {
		return false;
	}

	@Override
	public AbstractBoundingBoxRule createBoundingBoxRule(String column, Double xmin, Double ymin, Double xmax,
			Double ymax) {
		return BoundingBoxRule.of(column, getSrid(), xmin, ymin, xmax, ymax);
	}

	@Override
	public AbstractIntersectsByPoint2DRule createIntersectsByPoint2DRule(String column, Double x, Double y) {
		return IntersectsByPoint2DRule.of(column, getSrid(), x, y);
	}

}
