package es.prodevelop.pui9.geo.filter.rules;

import javax.annotation.Nullable;

public class IntersectsByPoint2DRule extends AbstractIntersectsByPoint2DRule {

	private static final long serialVersionUID = 1L;

	@Nullable
	public static IntersectsByPoint2DRule of(String field, Integer srid, Double x, Double y) {
		return new IntersectsByPoint2DRule(field, srid, x, y);
	}

	private IntersectsByPoint2DRule() {
		this(null, null, null, null);
	}

	private IntersectsByPoint2DRule(String field, Integer srid, Double x, Double y) {
		super(field, srid, x, y);
	}

	@Override
	public String getSql() {
		StringBuilder sb = new StringBuilder();
		sb.append(getField());
		sb.append(".STIntersects(");
		sb.append("geometry::STGeomFromText('POINT(" + getX() + ", " + getY() + ")'," + getSrid() + ")");
		sb.append(") = 1");

		return sb.toString();
	}

}
