package es.prodevelop.pui9.geo.filter.rules;

import javax.annotation.Nullable;

public class BoundingBoxRule extends AbstractBoundingBoxRule {

	private static final long serialVersionUID = 1L;

	@Nullable
	public static BoundingBoxRule of(String field, Integer srid, Double xmin, Double ymin, Double xmax, Double ymax) {
		return new BoundingBoxRule(field, srid, xmin, ymin, xmax, ymax);
	}

	private BoundingBoxRule() {
		this(null, null, null, null, null, null);
	}

	private BoundingBoxRule(String field, Integer srid, Double xmin, Double ymin, Double xmax, Double ymax) {
		super(field, srid, xmin, ymin, xmax, ymax);
	}

	@Override
	public String getSql() {
		StringBuilder sb = new StringBuilder();
		sb.append(getField());
		sb.append(".STIntersects(");
		sb.append("geometry::STGeomFromText('LINESTRING(" + getXmin() + "," + getYmin() + "," + getXmax() + ","
				+ getYmax() + ")', " + getSrid() + ")");
		sb.append(".STEnvelope()");
		sb.append(") = 1");

		return sb.toString();
	}

}
