package es.prodevelop.pui9.geo.helpers;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.locationtech.jts.geom.Geometry;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import es.prodevelop.pui9.geo.dao.helpers.IDatabaseGeoHelper;
import es.prodevelop.pui9.geo.filter.rules.AbstractBoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.AbstractIntersectsByPoint2DRule;
import es.prodevelop.pui9.geo.filter.rules.BoundingBoxRule;
import es.prodevelop.pui9.geo.filter.rules.IntersectsByPoint2DRule;

@Component
public class SqlServerDatabaseGeoHelper implements IDatabaseGeoHelper {

	private JdbcTemplate jdbcTemplate;
	private Integer srid;

	public Integer getSrid() {
		if (srid == null) {
			StringBuilder sb = new StringBuilder();
			sb.append("select ");
			sb.append("t.name as entity, ");
			sb.append("c.name as columnname ");
			sb.append("from sys.columns c ");
			sb.append("join sys.tables t on t.object_id = c.object_id ");
			sb.append("where type_name(user_type_id) = 'geometry'");

			List<Map<String, Object>> res = jdbcTemplate.queryForList(sb.toString());
			for (Map<String, Object> map : res) {
				String entity = (String) map.get("entity");
				String columnname = (String) map.get("columnname");

				sb = new StringBuilder();
				sb.append("select top 1 " + columnname + ".STSrid as srid from " + entity);
				List<Map<String, Object>> res2 = jdbcTemplate.queryForList(sb.toString());
				for (Map<String, Object> map2 : res2) {
					if (map2.containsKey("srid")) {
						srid = (Integer) map.get("srid");
						if (srid != null && srid > 0) {
							break;
						}
					}
				}
			}
		}
		return srid;
	}

	@Override
	public String modifyColumnValue(String value) {
		StringBuilder sb = new StringBuilder();
		sb.append("geometry::STGeomFromText('" + value + "', ");
		sb.append(getSrid());
		sb.append(")");

		return sb.toString();
	}

	@Override
	public String fillGeometryValue(String geoColumnName) {
		StringBuilder sb = new StringBuilder();
		sb.append(geoColumnName);
		sb.append(".STAsText() as ");
		sb.append(geoColumnName);

		return sb.toString();
	}

	@Override
	public void setGeometryValue(Geometry jtsGeometry, int geometryDimension, PreparedStatement ps, int position)
			throws SQLException {
		ps.setString(position, jtsGeometry.toString());
	}

	@Override
	public boolean supportsNativeGeometry() {
		return false;
	}

	@Override
	public AbstractBoundingBoxRule createBoundingBoxRule(String column, Double xmin, Double ymin, Double xmax,
			Double ymax) {
		return BoundingBoxRule.of(column, getSrid(), xmin, ymin, xmax, ymax);
	}

	@Override
	public AbstractIntersectsByPoint2DRule createIntersectsByPoint2DRule(String column, Double x, Double y) {
		return IntersectsByPoint2DRule.of(column, getSrid(), x, y);
	}

}
