package es.prodevelop.pui9.elasticsearch.analysis;

import java.util.Map;

/**
 * Support class for the information of the SQL Join of the Views in the
 * database
 * 
 * @author Marc Gil - mgil@prodevelop.es
 */
public class JoinTableDef {
	private String tableName;
	private String tableAlias;
	private String joinCode;
	private Map<String, String> nameAliasMap;

	public JoinTableDef(String tableName, String tableAlias, String joinCode, Map<String, String> nameAliasMap) {
		this.tableName = tableName;
		this.tableAlias = tableAlias;
		this.joinCode = joinCode;
		this.nameAliasMap = nameAliasMap;
	}

	/**
	 * Get the table name
	 * 
	 * @return The table name
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * Get the alias of the table in the join (if has one)
	 * 
	 * @return The alias of the table in the join
	 */
	public String getTableAlias() {
		return tableAlias;
	}

	/**
	 * The SQL code of the join
	 * 
	 * @return The SQL code of the join
	 */
	public String getJoinCode() {
		return joinCode;
	}

	/**
	 * The map of name-alias of the columns of the view
	 * 
	 * @return A map of name-alias of the columns of the view
	 */
	public Map<String, String> getNameAliasMap() {
		return nameAliasMap;
	}

	@Override
	public String toString() {
		return joinCode;
	}
}